% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paper_emissions.R
\name{paper_emissions}
\alias{paper_emissions}
\title{Paper Emissions}
\usage{
paper_emissions(
  board = 0,
  mixed = 0,
  paper = 0,
  board_WD = 0,
  mixed_WD = 0,
  paper_WD = 0,
  waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  units = c("kg", "tonnes")
)
}
\arguments{
\item{board}{Numeric value indicating the weight of paperboard. Default is \code{0}.}

\item{mixed}{Numeric value indicating the weight of mixed paper. Default is \code{0}.}

\item{paper}{Numeric value indicating the weight of paper. Default is \code{0}.}

\item{board_WD}{Numeric value indicating the weight of paperboard disposed of using waste disposal methods. Default is \code{0}.}

\item{mixed_WD}{Numeric value indicating the weight of mixed paper disposed of using waste disposal methods. Default is \code{0}.}

\item{paper_WD}{Numeric value indicating the weight of paper disposed of using waste disposal methods. Default is \code{0}.}

\item{waste_disposal}{Character vector specifying the waste disposal method to use for calculating emissions. Possible values: \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"}. Default is \code{"Closed-loop"}.
\code{"Closed-loop"} is the process of recycling material back into the same product.
\code{"Combustion"} energy is recovered from the waste through incineration and subsequent generation of electricity.
\code{"Compost"} CO2e emitted as a result of composting a waste stream.
\code{"Landfill"} the product goes to landfill after use.}

\item{units}{Character vector specifying the units of the emissions output. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}
}
\value{
The function returns the calculated paper emissions as a numeric value in tonnes.
}
\description{
This function calculates the emissions produced from different paper sources based on the specified inputs. It considers emissions from primary material production and waste disposal of paper materials.
}
\examples{
paper_emissions(board = 10, board_WD = 10, paper = 100, paper_WD = 100, units = "kg")
}
