% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_diagnostics.R
\name{check_diagnostics}
\alias{check_diagnostics}
\title{Quick Diagnostics Checks for \code{run_mcmc} Output}
\usage{
check_diagnostics(x)
}
\arguments{
\item{x}{Results object of class \code{mcmc_output} from
\code{\link{run_mcmc}}.}
}
\description{
Prints out the acceptance rate, smallest effective sample sizes (ESS) and
largest Rhat values for a quick first check that the sampling worked. For
further checks, see e.g. \code{bayesplot} and \code{coda} packages.
}
\details{
For methods other than IS-MCMC, the estimates are based on the improved
diagnostics from the \code{posterior} package.For IS-MCMC, these Rhat,
bulk-ESS, and tail-ESS estimates are based on the approximate posterior
which should look reasonable, otherwise the IS-correction does not make much
sense. For IS-MCMC, ESS estimates based on a weighted posterior are also
computed.
}
\examples{
set.seed(1)
n <- 30
phi <- 2
rho <- 0.9
sigma <- 0.1
beta <- 0.5
u <- rexp(n, 0.1)
x <- rnorm(n)
z <- y <- numeric(n)
z[1] <- rnorm(1, 0, sigma / sqrt(1 - rho^2))
y[1] <- rnbinom(1, mu = u * exp(beta * x[1] + z[1]), size = phi)
for(i in 2:n) {
  z[i] <- rnorm(1, rho * z[i - 1], sigma)
  y[i] <- rnbinom(1, mu = u * exp(beta * x[i] + z[i]), size = phi)
}

model <- ar1_ng(y, rho = uniform_prior(0.9, 0, 1), 
  sigma = gamma_prior(0.1, 2, 10), mu = 0., 
  phi = gamma_prior(2, 2, 1), distribution = "negative binomial",
  xreg = x, beta = normal_prior(0.5, 0, 1), u = u)
  
out <- run_mcmc(model, iter = 1000, particles = 10)
check_diagnostics(out)
}
