% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acast.R
\name{acast}
\alias{acast}
\alias{acast.default}
\title{Simple and Fast Casting/Pivoting of an Array}
\usage{
acast(x, ...)

\method{acast}{default}(
  x,
  margin,
  grp,
  fill = FALSE,
  fill_val = if (is.atomic(x)) NA else list(NULL),
  ...
)
}
\arguments{
\item{x}{an atomic or recursive array.}

\item{...}{further arguments passed to or from methods. \cr \cr}

\item{margin}{a scalar integer, specifying the margin to cast from.}

\item{grp}{a factor, where \code{length(grp) == dim(x)[margin]}, with at least \code{2} unique values,
specifying which indices of \code{dim(x)[margin]} belong to which group. \cr
Each group will be cast onto a separate index of dimension \code{ndim(x) + 1}. \cr
Unused levels of \code{grp} will be dropped. \cr
Any \code{NA} values or levels found in \code{grp} will result in an error.}

\item{fill}{Boolean. \cr
When factor \code{grp} is unbalanced (i.e. has unequally sized groups)
the result will be an array where some slices have missing values, which need to be filled.
If \code{fill = TRUE}, an unbalanced \code{grp} factor is allowed,
and missing values will be filled with \code{fill_val}. \cr
If \code{fill = FALSE} (default), an unbalanced \code{grp} factor is not allowed,
and providing an unbalanced factor for \code{grp} produces an error. \cr
When \code{x} has type of \code{raw}, unbalanced \code{grp} is never allowed.}

\item{fill_val}{scalar of the same type of \code{x},
giving value to use to fill in the gaps when \code{fill = TRUE}. \cr
The \code{fill_val} argument is ignored when \code{fill = FALSE}
or when \code{x} has type of \code{raw}.}
}
\value{
An array with the following properties:
\itemize{
\item the number of dimensions of the output array is equal to \code{ndim(x) + 1};
\item the dimensions of the output array is equal to \verb{c(dim(x), max(tabulate(grp))};
\item the \code{dimnames} of the output array is equal to \code{c(dimnames(x), list(levels(grp)))}. \cr \cr
}
}
\description{
The \code{acast()} function spreads subsets of an array margin over a new dimension. \cr
Written in 'C' and 'C++' for high speed and memory efficiency. \cr
\cr
Roughly speaking, \code{acast()} can be thought of as the "array" analogy to
\code{data.table::dcast()}. \cr
But note 2 important differences:
\itemize{
\item \code{acast()} works on arrays instead of data.tables.
\item \code{acast()} casts into a completely new dimension
(namely \code{ndim(x) + 1}),
instead of casting into new columns.
}
}
\details{
For the sake of illustration, consider a matrix \code{x} and a grouping factor \code{grp}. \cr
Let the integer scalar \code{k} represent a group in \code{grp}, such that \code{k} \eqn{\in} \code{1:nlevels(grp)}. \cr
Then the code \cr
\code{out <- acast(x, margin = 1, grp = grp)} \cr
essentially performs the following for every group \code{k}:
\itemize{
\item copy-paste the subset \code{x[grp == k, ]} to the subset \code{out[, , k]}.
}

Please see the examples section
to get a good idea on how this function casts an array. \cr \cr
}
\section{Back transformation}{


From the casted array, \cr
\code{out <- acast(x, margin, grp)}, \cr
one can get the original \code{x} back by using \cr
\code{back <- asplit(out, ndim(out)) |> bind_array(along = margin)}. \cr
Note, however, the following about the back-transformed array \code{back}:
\itemize{
\item \code{back} will be ordered by \code{grp} along dimension \code{margin};
\item if the levels of \code{grp} did not have equal frequencies,
then \code{dim(back)[margin] > dim(x)[margin]},
and \code{back} will have more missing values than \code{x}. \cr \cr
}
}

\examples{

x <- cbind(id = c(rep(1:3, each = 2), 1), grp = c(rep(1:2, 3), 2), val = rnorm(7))
print(x)

grp <- as.factor(x[, 2])
levels(grp) <- c("a", "b")
margin <- 1L

acast(x, margin, grp, fill = TRUE)
}
\seealso{
\link{broadcast_casting} \cr
}
