% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrature_and_differentiation.R
\name{double_exponential_quadrature}
\alias{double_exponential_quadrature}
\alias{tanh_sinh}
\alias{sinh_sinh}
\alias{exp_sinh}
\title{Double Exponential Quadrature}
\usage{
tanh_sinh(f, a, b, tol = sqrt(.Machine$double.eps), max_refinements = 15)

sinh_sinh(f, tol = sqrt(.Machine$double.eps), max_refinements = 9)

exp_sinh(f, a, b, tol = sqrt(.Machine$double.eps), max_refinements = 9)
}
\arguments{
\item{f}{A function to integrate. It should accept a single numeric value and return a single numeric value.}

\item{a}{The lower limit of integration.}

\item{b}{The upper limit of integration.}

\item{tol}{The tolerance for the approximation. Default is \code{sqrt(.Machine$double.eps)}.}

\item{max_refinements}{The maximum number of refinements to apply. Default is 15 for tanh-sinh and 9 for sinh-sinh and exp-sinh.}
}
\value{
A single numeric value with the computed integral.
}
\description{
Functions for numerical integration using double exponential quadrature methods such as tanh-sinh, sinh-sinh, and exp-sinh quadrature.
}
\examples{
# Tanh-sinh quadrature of log(x) from 0 to 1
tanh_sinh(function(x) { log(x) * log1p(-x) }, a = 0, b = 1)
# Sinh-sinh quadrature of exp(-x^2)
sinh_sinh(function(x) { exp(-x * x) })
# Exp-sinh quadrature of exp(-3*x) from 0 to Inf
exp_sinh(function(x) { exp(-3 * x) }, a = 0, b = Inf)
}
