% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{html_chapters}
\alias{html_chapters}
\alias{html_book}
\alias{tufte_html_book}
\title{Build book chapters into separate HTML files}
\usage{
html_chapters(
  toc = TRUE,
  number_sections = TRUE,
  fig_caption = TRUE,
  lib_dir = "libs",
  template = bookdown_file("templates/default.html"),
  global_numbering = !number_sections,
  pandoc_args = NULL,
  ...,
  base_format = rmarkdown::html_document,
  split_bib = TRUE,
  page_builder = build_chapter,
  split_by = c("chapter", "section", "0", "1", "2", "3", "4", "5", "6", "chapter+number",
    "section+number", "0+number", "1+number", "2+number", "3+number", "4+number",
    "5+number", "6+number", "rmd", "none")
)

html_book(...)

tufte_html_book(...)
}
\arguments{
\item{toc, number_sections, fig_caption, lib_dir, template, pandoc_args}{See
\code{rmarkdown::\link[rmarkdown]{html_document}},
\code{tufte::\link[tufte:tufte_handout]{tufte_html}}, or the documentation
of the \code{base_format} function.}

\item{global_numbering}{If \code{TRUE}, number figures and tables globally
throughout a document (e.g., Figure 1, Figure 2, ...). If \code{FALSE},
number them sequentially within sections (e.g., Figure 1.1, Figure 1.2,
..., Figure 5.1, Figure 5.2, ...). Note that \code{global_numbering =
FALSE} will not work with \code{number_sections = FALSE} because sections
are not numbered.}

\item{...}{Other arguments to be passed to \code{base_format}. For
\code{html_book()} and \code{tufte_html_book()}, \code{...} is passed to
\code{html_chapters()}.}

\item{base_format}{An output format function to be used as the base format.}

\item{split_bib}{Whether to split the bibliography onto separate pages where
the citations are actually used.}

\item{page_builder}{A function to combine different parts of a chapter into a
page (an HTML character vector). See \code{\link{build_chapter}} for the
specification of this function.}

\item{split_by}{How to name the HTML output files from the book: \code{rmd}
uses the base filenames of the input Rmd files to create the HTML
filenames, e.g. generate \file{chapter1.html} for \file{chapter1.Rmd};
\code{none} or \code{"0"} means do not split the HTML file (the book will be
a single HTML file); \code{chapter} or \code{"1"} means split the file by
the first-level headers; \code{section} or \code{"2"} means the second-level
headers, \code{"3"}-\code{"6"} means split the file by the [3-6]-level
headers. For \code{chapter}, \code{section} and \code{"1"}-\code{"6"}, the
HTML filenames will be determined by the header ID's, e.g. the filename
for the first chapter with a chapter title \code{# Introduction} will be
\file{introduction.html}; for \code{"chapter+number"}, \code{"section+number"}
and \code{"[1-6]+number"} the chapter/section (and higher level section)
numbers will be prepended to the HTML filenames, e.g.
\file{1-introduction.html} and \file{2-1-literature.html}.}
}
\value{
An R Markdown output format object to be passed to
  \code{bookdown::render_book()}.
}
\description{
Split the HTML output into chapters while updating relative links (e.g. links
in TOC, footnotes, citations, figure/table cross-references, and so on).
Functions \code{html_book()} and \code{tufte_html_book()} are simple wrapper
functions of \code{html_chapter()} using a specific base output format.
}
\note{
These functions are expected to be used in conjunction with
  \code{\link{render_book}()}. It is almost meaningless if they are used with
  \code{rmarkdown::render()}. Functions like \code{\link{html_document2}} are
  designed to work with the latter.

  If you want to use a different template, the template must contain three
  pairs of HTML comments: \samp{<!--bookdown:title:start-->} and
  \samp{<!--bookdown:title:end-->} to mark the title section of the book
  (this section will be placed only on the first page of the rendered book);
  \samp{<!--bookdown:toc:start-->} and \samp{<!--bookdown:toc:end-->} to mark
  the table of contents section (it will be placed on all chapter pages);
  \samp{<!--bookdown:body:start-->} and \samp{<!--bookdown:body:end-->} to
  mark the HTML body of the book (the HTML body will be split into separate
  pages for chapters). You may open the default HTML template
  (\code{bookdown:::bookdown_file('templates/default.html')}) to see where
  these comments were inserted.
}
