% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compress.R
\name{blosc_compress}
\alias{blosc_compress}
\alias{blosc_decompress}
\title{Compress and decompress with Blosc}
\usage{
blosc_compress(
  x,
  compressor = "blosclz",
  level = 7L,
  shuffle = "noshuffle",
  typesize = 4L,
  ...
)

blosc_decompress(x, ...)
}
\arguments{
\item{x}{In case of \code{blosc_decompress()}, \code{x} should always be \code{raw} data
to be decompressed. Use \code{...} arguments to convert decompressed data
to a specific data type.

In case of \code{blosc_compress()}, \code{x} should either be \code{raw} data or a
\code{vector} of data to be compressed. In the latter case, you need to specify
\code{dtype} (see \code{r_to_dtype()}) in order to convert the data to \code{raw} information
first. See \code{vignette("blosc-compression")} for more details.}

\item{compressor}{The compression algorithm to be used. Can be any of
\code{"blosclz"}, \code{"lz4"}, \code{"lz4hc"}, \code{"zlib"}, or \code{"zstd"}.}

\item{level}{An \code{integer} indicating the required level of compression.
Needs to be between \code{0} (no compression) and \code{9} (maximum compression).}

\item{shuffle}{A shuffle filter to be activated before compression.
Should be one of \code{"noshuffle"}, \code{"shuffle"}, or \code{"bitshuffle"}.}

\item{typesize}{BLOSC compresses arrays of structured data. This argument
specifies the size (\code{integer}) of the data structure / type in bytes.
Default is \code{4L} bytes (i.e. 32 bits), which would be suitable for compressing
32 bit integers.}

\item{...}{Arguments passed to \code{r_to_dtype()}.}
}
\value{
In case of \code{blosc_compress()} a vector of compressed \code{raw}
data is returned. In case of \code{blosc_decompress()} returns a vector of
decompressed \code{raw} data. Or in in case \code{dtype} (see \code{dtype_to_r()}) is
specified, a vector of the specified type is returned.
}
\description{
Use the Blosc library to compress or decompress data.
}
\examples{
my_dat        <- as.raw(sample.int(2L, 10L*1024L, replace = TRUE) - 1L)
my_dat_out    <- blosc_compress(my_dat, typesize = 1L)
my_dat_decomp <- blosc_decompress(my_dat_out)

## After compressing and decompressing the data is the same as the original:
all(my_dat == my_dat_decomp)
}
