% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.R
\name{est_weighted}
\alias{est_weighted}
\alias{print.est_weighted}
\alias{summary.est_weighted}
\title{Calculate Weighted Estimate of (Discrete) Outcomes By Race}
\usage{
est_weighted(
  r_probs,
  formula,
  data = NULL,
  weights = NULL,
  prefix = "pr_",
  se_boot = 0
)

\method{print}{est_weighted}(x, ...)

\method{summary}{est_weighted}(object, ...)
}
\arguments{
\item{r_probs}{A data frame or matrix of BISG probabilities, with one row per
individual. The output of [bisg()] can be used directly here.}

\item{formula}{A two-sided formula object describing the estimator structure.
The left-hand side is the outcome variable, which must be discrete.
Subgroups for which to calculate estimates may be specified by adding
covariates on the right-hand side. Subgroup estimates are available with
`coef(..., subgroup=TRUE)` and `tidy(..., subgroup=TRUE)`.}

\item{data}{An optional data frame containing the variables named in `formula`.}

\item{weights}{An optional numeric vector specifying weights.}

\item{prefix}{If `r_probs` is a data frame, the columns containing racial
probabilities will be selected as those with names starting with `prefix`.
The default will work with the output of [bisg()].}

\item{se_boot}{The number of bootstrap replicates to use to compute
an approximate covariance matrix for the estimator. If no bootstrapping is
used, an analytical estimate of standard errors will be returned as `$se`.
For bootstrapping, when there are fewer than 1,000 individuals or 100 or
fewer replicates, a Bayesian bootstrap is used instead (i.e., weights are
drawn from a \eqn{\text{Dirichlet}(1, 1, ..., 1)} distribution, which
produces more reliable estimates.}

\item{...}{Additional arguments to generic methods (ignored).}

\item{object, x}{An object of class `est_weighted`.}
}
\value{
An object of class `est_weighted`, inheriting from
  [`birdie`][birdie::birdie-class], for which many methods are available. The
  model estimates may be accessed with `coef()`. Uncertainty estimates, if
  available, can be accessed with `$se` and [vcov.birdie()].
}
\description{
Calculates the "standard" weighted estimator of conditional distributions of
an outcome variable \eqn{Y} by race \eqn{R}, using BISG probabilities.  This
estimator, while commonly used, is only appropriate if \eqn{Y \perp R \mid X, S},
where \eqn{S} and \eqn{X} are the last names and covariates (possibly
including geography) used in making the BISG probabilities. In most cases
this assumption is not plausible and [birdie()] should be used instead. See
the references below for more discussion as to selecting the right estimator.

Up to Monte Carlo error, the weighted estimate is equivalent to performing
multiple imputations of the race vector from the BISG probabilities and then
using them inside a weighted average or linear regression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(est_weighted)}: Print a summary of the model fit.

\item \code{summary(est_weighted)}: Print a more detailed summary of the model fit.

}}
\examples{
data(pseudo_vf)

r_probs = bisg(~ nm(last_name) + zip(zip), data=pseudo_vf)

# Process zip codes to remove missing values
pseudo_vf$zip = proc_zip(pseudo_vf$zip)

est_weighted(r_probs, turnout ~ 1, data=pseudo_vf)

est = est_weighted(r_probs, turnout ~ zip, data=pseudo_vf)
tidy(est, subgroup=TRUE)

}
\references{
McCartan, C., Fisher, R., Goldin, J., Ho, D.E., & Imai, K. (2024).
Estimating Racial Disparities when Race is Not Observed.
Available at \url{https://www.nber.org/papers/w32373}.
}
\concept{estimators}
