% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_vpts_aloft.R
\name{list_vpts_aloft}
\alias{list_vpts_aloft}
\title{List aloft urls for time series of vertical profiles (\code{vpts}) of radar
stations}
\usage{
list_vpts_aloft(
  date_min = NULL,
  date_max = NULL,
  radars = NULL,
  format = "csv",
  source = "baltrad",
  show_warnings = TRUE
)
}
\arguments{
\item{date_min}{Character, the first date to return urls for. In the shape of
YYYY-MM-DD.}

\item{date_max}{Character, the last date to return urls for. In the shape of
YYYY-MM-DD.}

\item{radars}{Character vector, radar stations to return urls for.}

\item{format}{Character, the format of archive urls to return, either csv or
hdf5. Currently only csv urls are supported.}

\item{source}{Character, either \code{baltrad} or \code{ecog-04003}}

\item{show_warnings}{Logical, whether to print warnings for dates or radar
stations for which no data was found.}
}
\value{
A character vector of aloft urls
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function has been superseded by \code{getRad::get_vpts()} and
\code{getRad::aloft_data_coverage()}.
}
\examples{
\donttest{
if (requireNamespace("aws.s3", quietly = TRUE)) {
list_vpts_aloft(radars = "bejab", date_min='2018-10-01', date_max = '2018-12-31')
}}
}
