% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class003-bids_property.R
\name{bids_property}
\alias{bids_property}
\alias{bids_property_optional}
\alias{bids_property_required}
\alias{bids_property_prohibited}
\alias{bids_property_recommended}
\alias{bids_property_deprecated}
\alias{bids_property_character}
\alias{bids_property_collapsed_character}
\alias{bids_property_choice}
\alias{bids_property_numeric}
\alias{bids_property_integerish}
\alias{bids_property_list}
\alias{bids_property_named_list}
\alias{bids_property_unnamed_list}
\alias{bids_property_entity_list}
\alias{bids_property_tabular_column_descriptor_list}
\alias{bids_property_data_frame}
\alias{bids_property_tabular_content}
\alias{bids_property_tabular_meta}
\title{\code{'S7'} property for 'BIDS' classes}
\usage{
bids_property(
  name,
  class = S7::class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  final = FALSE,
  ...
)

bids_property_optional(
  name,
  class = S7::class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  max_len = 1L,
  ...
)

bids_property_required(
  name,
  class = S7::class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  len = 1L,
  ...
)

bids_property_prohibited(
  name,
  class = S7::class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...
)

bids_property_recommended(
  name,
  class = S7::class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  max_len = 1L
)

bids_property_deprecated(
  name,
  class = S7::class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  max_len = 1L
)

bids_property_character(
  name,
  type = c("optional", "recommended", "required", "deprecated", "prohibited"),
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  class = S7::class_character
)

bids_property_collapsed_character(
  name,
  type = c("optional", "recommended", "required", "deprecated", "prohibited"),
  collapse = " ",
  ...,
  class = S7::class_character
)

bids_property_choice(
  name,
  choices,
  type = c("optional", "recommended", "required", "deprecated", "prohibited"),
  ...,
  class = S7::class_character
)

bids_property_numeric(
  name,
  type = c("optional", "recommended", "required", "deprecated", "prohibited"),
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  class = S7::class_numeric
)

bids_property_integerish(
  name,
  type = c("optional", "recommended", "required", "deprecated", "prohibited"),
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  class = S7::class_numeric
)

bids_property_list(
  name,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  class = S7::class_list
)

bids_property_named_list(
  name,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = list(),
  ...,
  class = S7::class_list
)

bids_property_unnamed_list(
  name,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  ...,
  class = S7::class_list
)

bids_property_entity_list(
  name,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = list(),
  ...,
  class = S7::class_list,
  identifier = NULL,
  schema_key = NA,
  bids_version = current_bids_version()
)

bids_property_tabular_column_descriptor_list(
  name,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = list(),
  ...,
  class = S7::class_list
)

bids_property_data_frame(
  name,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = data.frame(),
  ...,
  class = S7::class_data.frame
)

bids_property_tabular_content(
  name = "content",
  setter = NULL,
  ...,
  name_meta = "meta",
  lower_case_column_names = FALSE
)

bids_property_tabular_meta(
  name = "meta",
  setter = NULL,
  preset = NULL,
  ...,
  name_content = "content"
)
}
\arguments{
\item{name}{required, string, name of the property}

\item{class}{\code{'S7'} class}

\item{getter, setter, validator, default}{see \code{\link[S7]{new_property}}}

\item{final}{whether the property is final once initialized; default is
false; this is for properties that should not be altered}

\item{...}{passed to other methods}

\item{max_len}{for \code{type='optional'}, maximum vector length of the
property; default is 1}

\item{len}{for \code{type='required'}, vector length of the property;
default is 1}

\item{type}{type of the property, can be \code{'required'},
\code{'optional'}, or \code{'prohibited'}}

\item{collapse}{for collapsed property, passed to \code{\link{paste}}}

\item{choices}{for properties that can only be chosen from given choices;
a character strings of candidate choices.}

\item{identifier}{\code{"data_type/suffix"} combination to get entity rules}

\item{schema_key}{'BIDS' schema key if explicit entity rules is needed}

\item{bids_version}{'BIDS' version to query the entity rules}

\item{name_meta}{for tabular content, the name of the meta property; default
is \code{"meta"}}

\item{lower_case_column_names}{for tabular content, whether to convert
column names to lower case; default is \code{FALSE}}

\item{preset}{a list of preset meta data; default is \code{NULL}}

\item{name_content}{for tabular meta, the name of the content property;
default is \code{"content"}}
}
\value{
All functions call \code{\link[S7]{new_property}} internally.
}
\description{
Used in \code{property} to generate properties with constraints in
class generators such as \code{\link{new_bids_class}}.
}
\examples{


MyClass <- new_bids_class(
  name = "MyClass",
  properties = list(
    str = bids_property_character(
      name = "str",
      type = "required",
      validator = function(value) {
        if (length(value) == 1 &&
            !isTRUE(is.na(value)) && nzchar(value)) {
          return()
        }
        return(sprintf("Invalid `str`: \%s", paste(sQuote(value), collapse = ", ")))
      }
    )
  ),
  methods = list(
    # read-only methods
    format = function(self, ...) {
      sprintf("MyClass@str -> \%s", self$str)
    }
  )
)

instance <- MyClass(str = "aha")
instance

instance$str <- "111"
instance


# what if you enter illegal values

try({
  MyClass(str = "")
})

try({
  MyClass(str = NA_character_)
})

try({
  MyClass(str = 1)
})



}
\author{
Zhengjia Wang
}
