% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class010-bids_map.R
\name{BIDSMap}
\alias{BIDSMap}
\title{Low-level nested map to store key-value data with inherited structure}
\usage{
BIDSMap(parent = NULL, search_depth = BIDS_MAP_MAX_DEPTH())
}
\arguments{
\item{parent}{\code{NULL} if the map is at the top level, or another
map to inherit}

\item{search_depth}{integer maximum search depths; default is \code{29};
set options \code{'bidsr.map.search_depth'} or environment variable
\code{'BIDS_MAP_MAX_DEPTH'} to change the default depth}
}
\value{
A \code{'BIDSMap'} object.
}
\description{
Low-level nested map to store key-value data with inherited structure
}
\examples{


root_map <- BIDSMap()
root_map$key1 <- 1
root_map$key2 <- 2
names(root_map)

child_map <- BIDSMap(parent = root_map)
child_map$key3 <- 3
names(child_map)
child_map$key1
child_map$key2

# mask key2
child_map$key2 <- "a"
child_map

root_map$key2
child_map$key2

# nested maps
grand_child <- BIDSMap(parent = child_map)

# value comes from child map
grand_child$key2

# remove key2 from child map
child_map@impl$remove("key2")

# key2 is from root map now
grand_child$key2


}
\author{
Zhengjia Wang
}
