% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.betapart.core.pairwise.R
\name{inter_rcdd_coord}
\alias{inter_rcdd_coord}
\title{Internal function to compute convexhull volume and vertice coordinates}
\usage{
inter_rcdd_coord(set1, set2, qhull.opt = "FA", conv2 = function(...) NA)
}
\arguments{
\item{set1}{A matrix of coordinates}

\item{set2}{A matrix of coordinates}

\item{qhull.opt}{Qhull options, see \url{http://www.qhull.org/html/qh-optq.htm}}

\item{conv2}{A function applyed if the convexhull function crashes}
}
\value{
{A list of 2 elements.
\describe{\item{coord}{ the vertice coordinates}
  \item{vol}{ a volume corresponding to the intersection of the two hypervolumes}
  }
}
}
\description{
Estimation of the convexhull volume and the vertices of the intersection of two hypervolumes based on rcdd functions
}
\examples{
\dontrun{mat1 <- matrix(runif(30), 10)
mat2 <- matrix(runif(30), 10)
inter_rcdd_coord(mat1, mat2)}
}
\seealso{
\code{\link{inter_geom_coord}}
}
