% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normTest.R
\name{normTest}
\alias{normTest}
\title{Test values for normality of distribution}
\usage{
normTest(
  v,
  plot = TRUE,
  main = deparse(substitute(v)),
  breaks = 15,
  col = "tan",
  legend = TRUE,
  ...
)
}
\arguments{
\item{v}{Vector of values to be tested for normality}

\item{plot}{Plot the histogram with the corresponding 
normal density distribution? DEFAULT: TRUE}

\item{main}{Graph title. DEFAULT: \code{deparse(substitute(v))}}

\item{breaks}{Number of bins. Exact, unlike in \code{\link{hist}}.
DEFAULT: 15}

\item{col}{Color of bars. DEFAULT: "tan"}

\item{legend}{Add legend text in topright? DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link{hist}}}
}
\value{
named vector of p values
}
\description{
Normality test: histogram with corresponding normal density distribution line, 
as well as p values for various normality tests.\cr
The package \code{nortest} is needed for full functionality.
}
\examples{
normTest(rnorm(1000, mean=97, sd=8.9))
# if p > 0.05: accept Nullhypothesis that data are normally distributed.
normTest(rexp(30))

if(requireNamespace("pbapply")) replicate <- pbapply::pbreplicate
par(mfcol=c(7,6), mar=c(0,0.1,1,0.1), oma=c(2.5,1.5,2.5,0), las=1)
invisible(sapply(c("rnorm(10)", "rnorm(100)", 
                   "rexp(10)", "rexp(100)", 
                   "runif(10)", "runif(100)"), function(vv){
  check <- replicate(1e2, normTest(v=eval(str2lang(vv)), plot=FALSE))
  for(n in rownames(check)) 
   {hist(check[n,], breaks=seq(0,1,len=20), axes=FALSE, ylab="", xlab="", main="")
   if(n=="ShapiroWilk") title(main=vv, line=1, xpd=NA)
   if(vv=="rnorm(10)") title(ylab=n, line=0, xpd=NA)
   abline(v=0.05, col="blue", lwd=1, xpd=TRUE)
   }
  axis(1, at=0:1)
  }))
title(main="P values of tests for normality with", outer=TRUE, line=1.5)

}
\seealso{
\code{\link{ks.test}}, \code{\link{shapiro.test}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sep 2021
}
\keyword{distribution}
