% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logAxis.R
\name{logAxis}
\alias{logAxis}
\title{Label logarithmic axes}
\usage{
logAxis(
  side = 1,
  log = NULL,
  lcol = "grey",
  lty = 1,
  lwd = 1,
  labels = NULL,
  allticks = FALSE,
  allargs = NULL,
  expr,
  las = 1,
  from,
  to,
  Range,
  base = NA,
  big.mark = "'",
  decimal.mark = ".",
  scientific = FALSE,
  exponent = 5,
  expobase1 = FALSE,
  allbase = 1:9,
  box = TRUE,
  ...
)
}
\arguments{
\item{side}{Which \code{\link{axis}} are to be labeled? Can be a vector within \code{1:4}. DEFAULT: 1}

\item{log}{Is the axis logarithmic by plot(log="x")? internal DEFAULT: \code{\link{par}("xlog")} or "ylog". DEFAULT: NULL}

\item{lcol}{Color of gridlines drawn in the graph with \code{\link{abline}}, NA to suppress. DEFAULT: "grey"}

\item{lty, lwd}{Type of gridlines. DEFAULT: 1}

\item{labels}{Labels passed to \code{\link{axis}}. "FALSE" to suppress labeling. DEFAULT: NULL (internally, \code{\link{logVals}$labs}}

\item{allticks}{Place all intermediate ticklines at the axis (without labeling). DEFAULT: FALSE}

\item{allargs}{List of arguments passed to axis for allticks=TRUE. DEFAULT: NULL}

\item{expr}{Expression drawing over the ablines, like (points(x,y). Can be code within curly braces.}

\item{las}{LabelAxisStyle for the orientation of the labels. DEFAULT: 1}

\item{from}{Lower exponent OR vector with data, as in \code{\link{logVals}}. DEFAULT based on \code{\link{par}("usr")}}

\item{to}{High end exponent. DEFAULT: internally based on par("usr")}

\item{Range}{Override from and to as range.}

\item{base}{Bases to be used in \code{\link{logVals}}. DEFAULT: NA -> c(1,2,5) or 1, depending on from and to.}

\item{big.mark}{Symbol separating thousands, eg. space, comma, dot, etc. see "format" and "prettyNum". DEFAULT: "'"}

\item{decimal.mark}{Character separating comma values, see "format" and "prettyNum". DEFAULT: "."}

\item{scientific}{See \code{\link{format}}. DEFAULT: FALSE}

\item{exponent}{Starting at which exponent should \code{\link{logVals}} return an expression with exponents? DEFAULT: 5}

\item{expobase1}{Should "n * " be appended before 10^exp if n=1? DEFAULT: FALSE}

\item{allbase}{base for \code{$all} (for horizontal lines). DEFAULT: 1:9}

\item{box}{Draw box at the end to overplot \code{\link{abline}s} crossing the box? DEFAULT: TRUE}

\item{\dots}{Further arguments passed to axis, like \code{lwd, col.ticks, hadj, lty}, ...}
}
\value{
An invisible list with
       \item{vals}{Values for lines and label positions}
       \item{labs}{Formatted values for labels}
       \item{all}{Values for lines}
}
\description{
Shortcut to calling \code{\link{logVals}}, \code{\link{axis}} and \code{\link{abline}}
}
\examples{

x <- 10^runif(200, -1, 2)
plot(x, yaxt="n", log="y", pch=16)
logAxis(2)
# overplot vertical lines:
logAxis(2, expr=points(x, pch=16), base=1, col.axis=4, font=2)

# plots where log="x" is not possible:
hist(log10(x), breaks=20, col.axis="grey", main="")
logAxis(side=3, expr=hist(log10(x), breaks=20, add=TRUE, col=3))
# or just use the new logHist function (Feb 2016):
logHist(x, breaks=20, col=3)

# automatic calculation of from, to and base:
plot(1:3, axes=FALSE)
logAxis(1:2) # side can be a vector - nice, huh?
plot(-1:4, axes=FALSE)
logAxis(1:2) # treshold for base 1 instead of c(1,2,5) at 4 exponents exceeded.

plot(1:3, axes=FALSE)
logAxis(1:2, allticks=TRUE, lcol=NA)

par(mar=c(3,3,1,4))
plot(8:15) ;  logAxis(4) # with exponents if they are above 5
plot(10^(1:4), ylim=10^c(4,1), type="o", log="y") # reverse axis:
plot(10^(1:5), log="y"); logAxis(4, exponent=3) # different treshold
plot(10^(1:5), log="y"); logAxis(4, expon=3, base=c(1,2,5), expobase1=TRUE)
plot(-8:5); logAxis(4, allbase=c(1,2,5)) # In case you want to mislead...

}
\seealso{
\code{\link{logVals}}, \code{\link{log10}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sept 2014
}
\keyword{aplot}
\keyword{dplot}
