% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Request.R
\name{Request}
\alias{Request}
\title{Request Class}
\description{
A \code{Request} object represents the HTTP request and has properties for
the request query string, parameters, body, HTTP headers, and so on.
In this documentation and by convention, the object is always referred to as
\code{req} (and the HTTP response is \code{res}).
}
\section{Fields}{


\describe{
  \item{\code{parameters}}{
  A list containing properties mapped to the named router parameters.
  }
  \item{\code{headers}}{
  A list of response headers.
  }
  \item{\code{path}}{
  Contains the path part of the request URL.
  }
  \item{\code{method}}{
  Contains a string corresponding to the HTTP method of the request:
  GET, POST, PUT, and so on.
  }
  \item{\code{raw}}{
  Returns the raw request (\code{req}) object.
  }
  \item{\code{type}}{
  Contains the body content-type, i.e. "text/html" or "application/json".
  }
  \item{\code{body}}{
  Contains the data submitted in the request body.
  }
  \item{\code{protocol}}{
  Contains the request protocol string.
  }
}
}

\section{Methods}{


\describe{
\item{\code{attach(key, value)}}{
  Returns a key-value.
  }
  \item{\code{getHeader(key)}}{
  Returns the key element of the \code{headers} list.
  }
  \item{\code{setHeader(key, value)}}{
  Attaches a header to \code{headers} list.
  }
  \item{\code{addParameters(named_list)}}{
  Adds parameters to the named key-value \code{parameters} list.
  }
  \item{\code{intialize(req)}}{
  Creates a new \code{Request} object by parsing and extracting features of
  \code{req} input and populating the object fields.
  }
}
}

\seealso{
\code{\link{Response}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-attach}{\code{Request$attach()}}
\item \href{#method-getHeader}{\code{Request$getHeader()}}
\item \href{#method-setHeader}{\code{Request$setHeader()}}
\item \href{#method-addParameters}{\code{Request$addParameters()}}
\item \href{#method-new}{\code{Request$new()}}
\item \href{#method-clone}{\code{Request$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-attach"></a>}}
\if{latex}{\out{\hypertarget{method-attach}{}}}
\subsection{Method \code{attach()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$attach(key, value)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getHeader"></a>}}
\if{latex}{\out{\hypertarget{method-getHeader}{}}}
\subsection{Method \code{getHeader()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getHeader(key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setHeader"></a>}}
\if{latex}{\out{\hypertarget{method-setHeader}{}}}
\subsection{Method \code{setHeader()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$setHeader(key, value)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addParameters"></a>}}
\if{latex}{\out{\hypertarget{method-addParameters}{}}}
\subsection{Method \code{addParameters()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$addParameters(named_list)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$new(req)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
