% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_space.R
\name{init_model_space_params}
\alias{init_model_space_params}
\title{Initialize model space matrix}
\usage{
init_model_space_params(
  df,
  timestamp_col,
  entity_col,
  dep_var_col,
  init_value = 1
)
}
\arguments{
\item{df}{Data frame with data for the SEM analysis.}

\item{timestamp_col}{Column which determines time periods. For now only
natural numbers can be used as timestamps}

\item{entity_col}{Column which determines entities (e.g. countries, people)}

\item{dep_var_col}{Column with dependent variable}

\item{init_value}{Initial value for parameters present in the model. Default
is \code{1}.}
}
\value{
matrix of model parameters
}
\description{
This function builds a representation of the model space, by creating a
dataframe where each column represents values of the parameters for a given
model. Real value means that the parameter is included in the model. A
parameter not present in the model is marked as \code{NA}.
}
\details{
Currently the set of features is assumed to be all columns which remain after
excluding \code{timestamp_col}, \code{entity_col} and \code{dep_var_col}.

A power set of all possible exclusions of linear dependence on the given
feature is created, i.e. if there are 4 features we end up with 2^4 possible
models (for each model we independently decide whether to include or not a
feature).
}
\examples{
library(magrittr)

data_prepared <- bdsm::economic_growth[, 1:5] \%>\%
  bdsm::feature_standardization(
    excluded_cols = c(country, year, gdp)
  ) \%>\%
  bdsm::feature_standardization(
    group_by_col  = year,
    excluded_cols = country,
    scale         = FALSE
  )

init_model_space_params(data_prepared, year, country, gdp)
}
