% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecx.R
\name{ecx}
\alias{ecx}
\title{Extracts the predicted ECx value}
\usage{
ecx(
  object,
  ecx_val = 10,
  resolution = 1000,
  posterior = FALSE,
  type = "absolute",
  hormesis_def = "control",
  x_range = NA,
  xform = identity,
  prob_vals = c(0.5, 0.025, 0.975)
)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}} returned by \code{\link{bnec}}.}

\item{ecx_val}{The desired percentage effect value. This must be a value
between 1 and 99 (for type = "relative" and "absolute"), defaults to 10.}

\item{resolution}{The number of unique x values over which to find ECx --
large values will make the ECx estimate more precise.}

\item{posterior}{A \code{\link[base]{logical}} value indicating if the full
posterior sample of calculated ECx values should be returned instead of
just the median and 95 credible intervals.}

\item{type}{A \code{\link[base]{character}} vector, taking values of
"relative", "absolute" (the default) or "direct". See Details.}

\item{hormesis_def}{A \code{\link[base]{character}} vector, taking values
of "max" or "control". See Details.}

\item{x_range}{A range of x values over which to consider extracting ECx.}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{prob_vals}{A vector indicating the probability values over which to
return the estimated ECx value. Defaults to 0.5 (median) and 0.025 and
0.975 (95 percent credible intervals).}
}
\value{
A vector containing the estimated ECx value, including upper and
lower 95\% credible interval bounds.
}
\description{
Extracts the predicted ECx value as desired from an object of class
\code{\link{bayesnecfit}} or \code{\link{bayesnecfit}}.
}
\details{
\code{type} "relative" is calculated as the percentage decrease
from the maximum predicted value of the response (top) to the minimum
predicted value of the response. Type "absolute" (the default) is
calculated as the percentage decrease from the maximum value of the
response (top) to 0. Type "direct"
provides a direct estimate of the x value for a given y.
Note that for the current version, ECx for an "nechorme" (NEC Hormesis)
model is estimated at a percent decline from the control.

For \code{hormesis_def}, if "max", then ECx values are calculated as a
decline from the maximum estimates (i.e. the peak at NEC);
if "control", then ECx values are calculated relative to the control, which
is assumed to be the lowest observed concentration.

Calls to functions \code{\link{ecx}} and \code{\link{nsec}} and
\code{\link{compare_fitted}} do not require the same level of flexibility
in the context of allowing argument \code{newdata}
(from a \code{\link[brms]{posterior_predict}} perspective) to
be supplied manually, as this is and should be handled within the function
itself. The argument \code{resolution} controls how precisely the
\code{\link{ecx}} or \code{\link{nsec}} value is estimated, with
argument \code{x_range} allowing estimation beyond the existing range of
the observed data (otherwise the default range) which can be useful in a
small number of cases. There is also no reasonable case where estimating
these from the raw data would be of value, because both functions would
simply return one of the treatment concentrations, making NOEC a better
metric in that case.
}
\examples{
\donttest{
library(brms)
library(bayesnec)
data(manec_example)
ecx(manec_example, ecx_val = 50)
ecx(manec_example)
}

}
\seealso{
\code{\link{bnec}}
}
