% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-phenips-clim.R
\encoding{UTF-8}
\name{model.phenips_clim.apply}
\alias{model.phenips_clim.apply}
\title{Use PHENIPS-Clim}
\arguments{
\item{...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.
See \code{\link[=phenology]{phenology()}} for details.}

\item{tmin, tmean, tmax}{Daily minimum/mean/maximum temperatures in °C. \code{tmin}
is optional. If available it will be used to
calculate the temperature amplitude. If not, \code{(tmax - tmean) * 2} will be
used as amplitude.}

\item{rad}{Daily radiation in W * h / m^2.}

\item{daylength}{Length of the day in hours. Can be created with
\code{\link[=create_daylength_rst]{create_daylength_rst()}} or \code{\link[=create_daylength_rst]{create_daylength_rst()}}.}

\item{sister_broods}{Set \code{FALSE} to disable the calculation of sister broods.}

\item{scenario}{Choose a scenario to use a suitable combination of parameters
for specific situations. The scenario defines a default value for each value
that can be overwritten by specifying a value for the respective parameter.
The following scenarios are available:
\itemize{
\item mean: \code{list(exposure = 'sunny', onset_mode = 0.5, diapause_mode = 'photoperiodic', oviposition_mode = 0.5)}
\item max: \code{list(exposure = 'sunny', onset_mode = 0.1, diapause_mode = 'thermal', oviposition_mode = 0.1)}
}}

\item{exposure}{Specifies the sun exposure. Can be \code{'sunny'}(default) or \code{'shaded'}.}

\item{onset_mode}{Share of beetles that are already infesting trees necessary to
trigger the onset. Must be \code{0.1}, \code{0.5} or \code{0.9} if not customized.}

\item{oviposition_mode}{Share of beetles that should have finished oviposition
to trigger the beginning of the development. Must be \code{0.1}, \code{0.5} or \code{0.9} if not customized.}

\item{diapause_mode}{Determines how the diapause is initiated. Can be one of
the following options:
\itemize{
\item \code{'photoperiodic'}: The diapause is initiated when the daylength falls below
a specific threshold.
\item \code{'thermal'}: The diapause is initiated by a logistic model that depends on
the daylength and the maximum temperature.
}

Share of beetles that already stopped reproducing necessary to
trigger the diapause. Must be \code{thermal} or \code{'photoperiodic'} if not customized.
If \code{'photoperiodic'} is chosen, the diapause is controlled by a daylength
threshold (see parameter daylength_dia \link[=model.phenips_clim.customize]{here}).}
}
\description{
This page describes the usage of PHENIPS-Clim with \code{\link[=phenology]{phenology()}}.
The model specific inputs are listed and its basic functionality is explained.
PHENIPS-Clim is not published yet. This manual will be updated when a
publication is available. It was parametrized for \emph{Ips typographus} in southern Germany.
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply PHENIPS-Clim and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{phenology("phenips-clim", ..., tmin, tmean, tmax, rad, daylength,
          sister_broods = TRUE, scenario = 'max', exposure = NULL,
          onset_mode = NULL, oviposition_mode = NULL, diapause_mode = NULL)

# calculate submodels separately
phenology("phenips-clim", ..., .submodels = 'onset', tmax, scenario = 'max', onset_mode = NULL)
phenology("phenips-clim", ..., .submodels = 'diapause', tmax, daylength, scenario = 'max', diapause_mode = NULL)
phenology("phenips-clim", ..., .submodels = 'mortality', tmin)
phenology("phenips-clim", ..., .submodels = 'development',
          .onset, .diapause = NULL, .mortality = NULL,
          tmin, tmean, tmax, rad, sister_broods = TRUE,
          scenario = 'max', exposure = NULL, oviposition_mode = NULL)
}\if{html}{\out{</div>}}
}
\section{Functioning}{


In the following, the basic functioning of PHENIPS-Clim is explained.
\itemize{
\item \strong{Onset}: A base onset is triggered by a logistic model that relates to the
maximum temperature and the respective degree days. Beginning from the base onset,
a specific level of degree days (depending on the share of individuals that
should be accounted for)  and maximum air temperature must be reached to
trigger the actual onset.
\item \strong{Development}: While the bark temperature and the emergence of new
generations are determined according to \link[=model.phenips.apply]{PHENIPS}, the
calculation of the beetles' development rates is refined. Rather than implying
a constant development within a day, temperature fluctuations are incorporated
by taking the daily temperature amplitude into account. Additionally, the
first part of development represents the pre-oviposition period and will
not appear in the resulting output.
\item \strong{Diapause}: The diapause can be initiated due to the photoperiod according
to \link[=model.phenips.apply]{PHENIPS} or by a logistic model that depends on the
daylength and the maximum temperature and accounts for beetles that reproduce
even on shorter days if the temperatures are favorable. In the second case,
PHENIPS-Clim detects a reproductive arrest, due to adverse abiotic parameters,
and not an actual diapause as the output can be adjusted, if conditions improve
and allow for further reproduction later in the season.
\item \strong{Mortality}: White stages (egg to pupa) die when the minimum temperature
falls below a specific threshold.
}

Look \link[=model.phenips_clim.customize]{here} to find out how the model parameters affect the actual calculations and which values are used by default.
}

\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.phenips_clim.customize}}

Other phenology applications: 
\code{\link{model.bso.apply}},
\code{\link{model.chapy.apply}},
\code{\link{model.joensson.apply}},
\code{\link{model.lange.apply}},
\code{\link{model.phenips.apply}},
\code{\link{model.rity.apply}}
}
\concept{phenology applications}
