% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBiogeoStatus.R
\name{plotBiogeoStatus}
\alias{plotBiogeoStatus}
\title{plotBiogeoStatus}
\usage{
plotBiogeoStatus(
  biogeo,
  regional = TRUE,
  reg.by = "country",
  borders = TRUE,
  col.features = "khaki",
  col.bg = "azure2",
  plot.range = FALSE,
  range = NULL,
  box = FALSE
)
}
\arguments{
\item{biogeo}{dataTable of the species occurrence including a 
column with the estimated biogeographical status of points.}

\item{regional}{logical, whether the whole world should be plotted as the 
background or only the region adjacent to the species countries of 
occurrence.}

\item{reg.by}{character, by countries where there are points or by area 
where the points are located.}

\item{borders}{logical, whether country limits should be plotted.}

\item{col.features}{colour for plotting features.}

\item{col.bg}{colour for plotting the background.}

\item{plot.range}{logical, if TRUE, range maps should be provided as 
a shapefile in argument range.}

\item{range}{shapefile, species range map.}

\item{box}{logical, includes frame with coordinates locations.}
}
\value{
This function plots the species occurrence with estimated 
biogeographical status of all points.
}
\description{
Plot the species occurrences showing the estimated biogeographical status 
of points.
}
