% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{engine}
\alias{engine}
\alias{new_engine}
\title{Create an encoding engine}
\usage{
engine(which = "standard")

new_engine(.alphabet = alphabet(), .config = new_config())
}
\arguments{
\item{which}{default \code{"standard"}. The base64 encoding engine to be used.
See details for more.}

\item{.alphabet}{an object of class \code{alphabet} as created with
\code{\link[=alphabet]{alphabet()}} or \code{\link[=new_alphabet]{new_alphabet()}}}

\item{.config}{an object of class \code{engine_config} as created with
\code{\link[=new_config]{new_config()}}}
}
\value{
an object of class \code{engine}.
}
\description{
Create an encoding engine
}
\details{
\subsection{Engines}{

By default, the "standard" base64 engine is used which is specified in
\href{https://datatracker.ietf.org/doc/html/rfc4648#section-4}{RFC 4648}.

Additional pre-configured base64 engines are provided these are:
\itemize{
\item \code{"standard_no_pad"}: uses the standard engine without padding
\item \code{"url_safe"}: uses a url-safe alphabet with padding
\item \code{"url_safe_no_pad"}: uses a url-safe alphabet without padding
}

See \href{https://docs.rs/base64/latest/base64/engine/general_purpose/index.html#constants}{base64 crate} for more.
}
}
\examples{
engine()
new_engine(alphabet("bcrypt"), new_config())
}
