% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertToLlamaCVFolds.R
\name{convertToLlamaCVFolds}
\alias{convertToLlamaCVFolds}
\title{Convert an ASScenario scenario object to a llama data object with cross-validation folds.}
\usage{
convertToLlamaCVFolds(
  asscenario,
  measure,
  feature.steps,
  algorithm.feature.steps,
  cv.splits
)
}
\arguments{
\item{asscenario}{[\code{\link{ASScenario}}]\cr
Algorithm selection scenario.}

\item{measure}{[\code{character(1)}]\cr
Measure to use for modelling.
Default is first measure in scenario.}

\item{feature.steps}{[\code{character}]\cr
Which instance feature steps are allowed?
Default are the default instance feature steps or all steps
in case no defaults were defined.}

\item{algorithm.feature.steps}{[\code{character}]\cr
Which algorithm feature steps are allowed?
Default are the default algorithm feature steps or all steps
in case no defaults were defined.}

\item{cv.splits}{[\code{data.frame}]\cr
Data frame defining the split of the data into cross-validation folds,
as returned by \code{\link{createCVSplits}}.
Default are the splits \code{asscenario$cv.splits}}
}
\value{
Result of calling \code{\link[llama]{input}} with data partitioned into folds.
}
\description{
For features, mean values are computed across repetitions.
For algorithms, repetitions are not supported at the moment and will result in an error.
}
