% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeIni.R
\name{write-ini}
\alias{write-ini}
\alias{writeIni}
\alias{writeIniFile}
\alias{writeIniAPI}
\title{Write configuration options in file or API}
\usage{
writeIni(
  listData,
  pathIni,
  opts = antaresRead::simOptions(),
  ...,
  default_ext = ".ini"
)

writeIniFile(listData, pathIni, overwrite = FALSE)

writeIniAPI(listData, pathIni, opts)
}
\arguments{
\item{listData}{\code{list}, modified list obtained by antaresRead:::readIniFile.}

\item{pathIni}{\code{Character}, Path to ini file.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}

\item{...}{Additional arguments.}

\item{default_ext}{Default extension used for config files.}

\item{overwrite}{logical, should file be overwritten if already exist?}
}
\description{
Write configuration options in file or API
}
\examples{

\dontrun{
pathIni <- "D:/exemple_test/settings/generaldata.ini"
generalSetting <- readIniFile(pathIni)
generalSetting$output$synthesis <- FALSE
writeIni(generalSetting, pathIni)
}
}
