% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotAIFERobertaTransformer.R
\name{.AIFERobertaTransformer}
\alias{.AIFERobertaTransformer}
\title{Child \code{R6} class for creation and training of \code{RoBERTa} transformers}
\description{
This class has the following methods:
\itemize{
\item \code{create}: creates a new transformer based on \code{RoBERTa}.
\item \code{train}: trains and fine-tunes a \code{RoBERTa} model.
}
}
\section{Create}{
 New models can be created using the \code{.AIFERobertaTransformer$create} method.
}

\section{Train}{
 To train the model, pass the directory of the model to the method \code{.AIFERobertaTransformer$train}.

Pre-Trained models which can be fine-tuned with this function are available at \url{https://huggingface.co/}.

Training of this model makes use of dynamic masking.
}

\references{
Liu, Y., Ott, M., Goyal, N., Du, J., Joshi, M., Chen, D., Levy, O., Lewis, M., Zettlemoyer, L., &
Stoyanov, V. (2019). RoBERTa: A Robustly Optimized BERT Pretraining Approach. \doi{10.48550/arXiv.1907.11692}

Hugging Face Documentation
\itemize{
\item \url{https://huggingface.co/docs/transformers/model_doc/roberta}
\item \url{https://huggingface.co/docs/transformers/model_doc/roberta#transformers.RobertaModel}
\item \url{https://huggingface.co/docs/transformers/model_doc/roberta#transformers.TFRobertaModel}
}
}
\seealso{
Other Transformers for developers: 
\code{\link{.AIFEBaseTransformer}},
\code{\link{.AIFEBertTransformer}},
\code{\link{.AIFEDebertaTransformer}},
\code{\link{.AIFEFunnelTransformer}},
\code{\link{.AIFELongformerTransformer}},
\code{\link{.AIFEMpnetTransformer}},
\code{\link{.AIFETrObj}}
}
\concept{Transformers for developers}
\section{Super class}{
\code{\link[aifeducation:.AIFEBaseTransformer]{aifeducation::.AIFEBaseTransformer}} -> \code{.AIFERobertaTransformer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-.AIFERobertaTransformer-new}{\code{.AIFERobertaTransformer$new()}}
\item \href{#method-.AIFERobertaTransformer-create}{\code{.AIFERobertaTransformer$create()}}
\item \href{#method-.AIFERobertaTransformer-train}{\code{.AIFERobertaTransformer$train()}}
\item \href{#method-.AIFERobertaTransformer-clone}{\code{.AIFERobertaTransformer$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_calculate_vocab"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_calculate_vocab'><code>aifeducation::.AIFEBaseTransformer$set_SFC_calculate_vocab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_check_max_pos_emb"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_check_max_pos_emb'><code>aifeducation::.AIFEBaseTransformer$set_SFC_check_max_pos_emb()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_create_final_tokenizer"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_create_final_tokenizer'><code>aifeducation::.AIFEBaseTransformer$set_SFC_create_final_tokenizer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_create_tokenizer_draft"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_create_tokenizer_draft'><code>aifeducation::.AIFEBaseTransformer$set_SFC_create_tokenizer_draft()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_create_transformer_model"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_create_transformer_model'><code>aifeducation::.AIFEBaseTransformer$set_SFC_create_transformer_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_save_tokenizer_draft"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_save_tokenizer_draft'><code>aifeducation::.AIFEBaseTransformer$set_SFC_save_tokenizer_draft()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFT_create_data_collator"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFT_create_data_collator'><code>aifeducation::.AIFEBaseTransformer$set_SFT_create_data_collator()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFT_cuda_empty_cache"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFT_cuda_empty_cache'><code>aifeducation::.AIFEBaseTransformer$set_SFT_cuda_empty_cache()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFT_load_existing_model"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFT_load_existing_model'><code>aifeducation::.AIFEBaseTransformer$set_SFT_load_existing_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_model_param"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_model_param'><code>aifeducation::.AIFEBaseTransformer$set_model_param()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_model_temp"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_model_temp'><code>aifeducation::.AIFEBaseTransformer$set_model_temp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_required_SFC"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_required_SFC'><code>aifeducation::.AIFEBaseTransformer$set_required_SFC()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_title"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_title'><code>aifeducation::.AIFEBaseTransformer$set_title()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFERobertaTransformer-new"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFERobertaTransformer-new}{}}}
\subsection{Method \code{new()}}{
Creates a new transformer based on \code{RoBERTa} and sets the title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFERobertaTransformer$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFERobertaTransformer-create"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFERobertaTransformer-create}{}}}
\subsection{Method \code{create()}}{
This method creates a transformer configuration based on the \code{RoBERTa} base architecture and a
vocabulary based on \verb{Byte-Pair Encoding} (BPE) tokenizer using the python \code{transformers} and \code{tokenizers}
libraries.

This method adds the following \emph{'dependent' parameters} to the base class' inherited \code{params} list:
\itemize{
\item \code{add_prefix_space}
\item \code{trim_offsets}
\item \code{num_hidden_layer}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFERobertaTransformer$create(
  ml_framework = "pytorch",
  model_dir,
  text_dataset,
  vocab_size = 30522,
  add_prefix_space = FALSE,
  trim_offsets = TRUE,
  max_position_embeddings = 512,
  hidden_size = 768,
  num_hidden_layer = 12,
  num_attention_heads = 12,
  intermediate_size = 3072,
  hidden_act = "gelu",
  hidden_dropout_prob = 0.1,
  attention_probs_dropout_prob = 0.1,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  trace = TRUE,
  pytorch_safetensors = TRUE,
  log_dir = NULL,
  log_write_interval = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ml_framework}}{\code{string} Framework to use for training and inference.
\itemize{
\item \code{ml_framework = "tensorflow"}: for 'tensorflow'.
\item \code{ml_framework = "pytorch"}: for 'pytorch'.
}}

\item{\code{model_dir}}{\code{string} Path to the directory where the model should be saved.}

\item{\code{text_dataset}}{Object of class \link{LargeDataSetForText}.}

\item{\code{vocab_size}}{\code{int} Size of the vocabulary.}

\item{\code{add_prefix_space}}{\code{bool} \code{TRUE} if an additional space should be inserted to the leading words.}

\item{\code{trim_offsets}}{\code{bool} \code{TRUE} trims the whitespaces from the produced offsets.}

\item{\code{max_position_embeddings}}{\code{int} Number of maximum position embeddings. This parameter also determines the maximum length of a sequence which
can be processed with the model.}

\item{\code{hidden_size}}{\code{int} Number of neurons in each layer. This parameter determines the dimensionality of the resulting text
embedding.}

\item{\code{num_hidden_layer}}{\code{int} Number of hidden layers.}

\item{\code{num_attention_heads}}{\code{int} Number of attention heads.}

\item{\code{intermediate_size}}{\code{int} Number of neurons in the intermediate layer of the attention mechanism.}

\item{\code{hidden_act}}{\code{string} Name of the activation function.}

\item{\code{hidden_dropout_prob}}{\code{double} Ratio of dropout.}

\item{\code{attention_probs_dropout_prob}}{\code{double} Ratio of dropout for attention probabilities.}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library codecarbon.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if sustainability should be tracked. A
list can be found on Wikipedia: \url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}.}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada. See the documentation of codecarbon for more
information \url{https://mlco2.github.io/codecarbon/parameters.html}.}

\item{\code{sustain_interval}}{\code{integer} Interval in seconds for measuring power usage.}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the progress should be printed to the console.}

\item{\code{pytorch_safetensors}}{\code{bool} Only relevant for pytorch models.
\itemize{
\item \code{TRUE}: a 'pytorch' model is saved in safetensors format.
\item \code{FALSE} (or 'safetensors' is not available): model is saved in the standard pytorch format (.bin).
}}

\item{\code{log_dir}}{Path to the directory where the log files should be saved.}

\item{\code{log_write_interval}}{\code{int} Time in seconds determining the interval in which the logger should try to update the log files. Only relevant
if \code{log_dir} is not \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does not return an object. Instead, it saves the configuration and vocabulary of the new
model to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFERobertaTransformer-train"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFERobertaTransformer-train}{}}}
\subsection{Method \code{train()}}{
This method can be used to train or fine-tune a transformer based on \code{RoBERTa} Transformer
architecture with the help of the python libraries \code{transformers}, \code{datasets}, and \code{tokenizers}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFERobertaTransformer$train(
  ml_framework = "pytorch",
  output_dir,
  model_dir_path,
  text_dataset,
  p_mask = 0.15,
  val_size = 0.1,
  n_epoch = 1,
  batch_size = 12,
  chunk_size = 250,
  full_sequences_only = FALSE,
  min_seq_len = 50,
  learning_rate = 0.03,
  n_workers = 1,
  multi_process = FALSE,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  trace = TRUE,
  keras_trace = 1,
  pytorch_trace = 1,
  pytorch_safetensors = TRUE,
  log_dir = NULL,
  log_write_interval = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ml_framework}}{\code{string} Framework to use for training and inference.
\itemize{
\item \code{ml_framework = "tensorflow"}: for 'tensorflow'.
\item \code{ml_framework = "pytorch"}: for 'pytorch'.
}}

\item{\code{output_dir}}{\code{string} Path to the directory where the final model should be saved. If the directory does not exist, it will be
created.}

\item{\code{model_dir_path}}{\code{string} Path to the directory where the original model is stored.}

\item{\code{text_dataset}}{Object of class \link{LargeDataSetForText}.}

\item{\code{p_mask}}{\code{double} Ratio that determines the number of words/tokens used for masking.}

\item{\code{val_size}}{\code{double} Ratio that determines the amount of token chunks used for validation.}

\item{\code{n_epoch}}{\code{int} Number of epochs for training.}

\item{\code{batch_size}}{\code{int} Size of batches.}

\item{\code{chunk_size}}{\code{int} Size of every chunk for training.}

\item{\code{full_sequences_only}}{\code{bool} \code{TRUE} for using only chunks with a sequence length equal to \code{chunk_size}.}

\item{\code{min_seq_len}}{\code{int} Only relevant if \code{full_sequences_only = FALSE}. Value determines the minimal sequence length included in
training process.}

\item{\code{learning_rate}}{\code{double} Learning rate for adam optimizer.}

\item{\code{n_workers}}{\code{int} Number of workers. Only relevant if \code{ml_framework = "tensorflow"}.}

\item{\code{multi_process}}{\code{bool} \code{TRUE} if multiple processes should be activated. Only relevant if \code{ml_framework = "tensorflow"}.}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library codecarbon.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if sustainability should be tracked. A
list can be found on Wikipedia: \url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}.}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada. See the documentation of codecarbon for more
information \url{https://mlco2.github.io/codecarbon/parameters.html}.}

\item{\code{sustain_interval}}{\code{integer} Interval in seconds for measuring power usage.}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the progress should be printed to the console.}

\item{\code{keras_trace}}{\code{int}
\itemize{
\item \code{keras_trace = 0}: does not print any information about the training process from keras on the console.
\item \code{keras_trace = 1}: prints a progress bar.
\item \code{keras_trace = 2}: prints one line of information for every epoch. Only relevant if \code{ml_framework = "tensorflow"}.
}}

\item{\code{pytorch_trace}}{\code{int}
\itemize{
\item \code{pytorch_trace = 0}: does not print any information about the training process from pytorch on the console.
\item \code{pytorch_trace = 1}: prints a progress bar.
}}

\item{\code{pytorch_safetensors}}{\code{bool} Only relevant for pytorch models.
\itemize{
\item \code{TRUE}: a 'pytorch' model is saved in safetensors format.
\item \code{FALSE} (or 'safetensors' is not available): model is saved in the standard pytorch format (.bin).
}}

\item{\code{log_dir}}{Path to the directory where the log files should be saved.}

\item{\code{log_write_interval}}{\code{int} Time in seconds determining the interval in which the logger should try to update the log files. Only relevant
if \code{log_dir} is not \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does not return an object. Instead the trained or fine-tuned model is saved to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFERobertaTransformer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFERobertaTransformer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFERobertaTransformer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
