% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{propagate_na_values}
\alias{propagate_na_values}
\title{Propagate NA Values for datetime values}
\usage{
propagate_na_values(partial)
}
\arguments{
\item{partial}{A list of partial date/time components.

\describe{
\item{Default value}{none}
}}
}
\value{
A list of date/time components with propagated \code{NA} values.
}
\description{
Propagates \code{NA} values through date/time components.
}
\details{
This function ensures that if a higher-order component (e.g., month) is \code{NA},
all lower-order components (e.g., day, hour, etc.) are also set to \code{NA}.
}
\examples{
# Propagate NA values through datetime components
partial_datetime <- list(
  year = "2020", month = NA_character_, day = "01",
  hour = "12", minute = NA_character_, second = "34"
)
propagated_datetime <- admiral:::propagate_na_values(partial_datetime)
print(propagated_datetime)

# Propagate NA values for datetime with missing higher order components
partial_missing <- list(
  year = NA_character_, month = "01", day = "01",
  hour = "12", minute = "00", second = "00"
)
propagated_missing <- admiral:::propagate_na_values(partial_missing)
print(propagated_missing)

partial_missing_date <- list(
  year = "2023", month = NA_character_, day = "01"
)
propagated_missing_date <- admiral:::propagate_na_values(partial_missing_date)
print(propagated_missing_date)

}
\keyword{internal}
