% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{get_dt_dtm_range}
\alias{get_dt_dtm_range}
\title{Get Range of Partial Date / Datetime}
\usage{
get_dt_dtm_range(dtc, create_datetime)
}
\arguments{
\item{dtc}{A character vector of dates in ISO 8601 format
(e.g., \code{"2022-12-15"}, \code{"2022-12"}, \code{"2022"}).
Partial dates are allowed.

\describe{
\item{Default value}{none}
}}

\item{create_datetime}{return the range in datetime format.

\describe{
\item{Default value}{none}
}}
}
\value{
A list containing two vectors of fully imputed dates
in \code{"YYYY-MM-DD"} or \code{"YYYY-MM-DDThh:mm:ss"} format - the lower and upper limit of the range.
}
\description{
Internal helper function to convert a character vector of (possibly partial) dates (\code{dtc})
into complete dates based on a specified imputation rule (\code{date_imputation}).
}
\details{
The functions replaces missing components in \code{dtc} with the earliest (lower bound)
and latest (upper bound) possible value. Missing year is replaced with \code{"0000"} for the
lower bound and \code{"9999"} for the upper bound.
}
\examples{
# Get Range from Partial Dates
dtc_dates <- c("2020-02-29", "2021-03")
imputed_dates_first <- admiral:::get_dt_dtm_range(dtc_dates, create_datetime = FALSE)
print(imputed_dates_first)


# Get Range from Partial Datetime
dtc_datetimes <- c("2020-02-29T12:00", "2021-03T14:30")
imputed_datetimes_first <- admiral:::get_dt_dtm_range(dtc_datetimes, create_datetime = TRUE)
print(imputed_datetimes_first)

# Edge case: Return empty character vector for empty input
imputed_empty <- admiral:::get_dt_dtm_range(character(0), create_datetime = TRUE)
print(imputed_empty)

}
\keyword{internal}
