% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Series.R
\name{Plot.Series}
\alias{Plot.Series}
\title{Cree una serie de tiempo dinámica/estática y flexible con tres diferentes
paquetes}
\usage{
Plot.Series(
  datos,
  tiempo,
  valores,
  categoria,
  freqRelativa = FALSE,
  invertir = FALSE,
  ylim,
  colores,
  titulo = "",
  labelX = "Periodo",
  labelY = "",
  libreria = c("highcharter", "plotly", "dygraphs"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un objeto clase serie de tiempo o vector numérico.}

\item{tiempo}{Lista de variable(s) tanto numéricas como categóricas que se
concatenaran para crear un único periodo temporal (\emph{ordenado ascendentemente}).}

\item{valores}{Variable numérica que contiene los valores que desea graficar.}

\item{categoria}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{freqRelativa}{Si es \code{FALSE} (\emph{valor predeterminado}) la serie graficada
representará las frecuencias absolutas (\emph{conteo}) más no las relativas (\emph{porcentaje}).}

\item{invertir}{Si es \code{FALSE} (\emph{valor predeterminado}) no se invertirá el eje
\code{Y}. Establézcalo en \code{TRUE} si desea que en el eje \code{Y} el número más alto
sea el más cercano al origen.}

\item{ylim}{Vector numérico que especifica el límite inferior y superior,
respectivamente, del eje \code{Y}. Si no se introduce algún valor se mostrará
todo el rango disponible para dicho eje.}

\item{colores}{Cadena de caracteres indicando los colores con los cuales se
deben colorear cada una de las series correspondiente a cada nivel del
argumento \code{categoria}. Si no se introduce algún vector se usará la paleta
\code{rainbow} por defecto.}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{labelX}{Cadena de caracteres indicando la etiqueta del eje \code{X}. Por
defecto se emplea el rótulo "Periodo".}

\item{labelY}{Cadena de caracteres indicando la etiqueta del eje \code{Y}.}

\item{libreria}{Cadena de caracteres que indica el paquete con el cual se
realizará la serie. Los valores permitidos son \code{"highcharter"}
(\emph{valor predeterminado}), \code{"plotly"} o \code{"dygraphs"}. Los valores se emparejarán
parcialmente.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
de acuerdo con la librería especificada para graficar la serie y cuyo objetivo
es personalizar pequeños detalles de ésta.
\itemize{
\item \code{LegendTitle}: Cadena de caracteres indicando un título para la leyenda
(\emph{diferentes niveles del argumento \code{categorias}}). Se utilizará tanto
en el paquete \code{Highcharter} como en \code{Plotly}.
\item \code{hc.Tema}: Modifica el tema con el cual se creará la serie. Los posibles
valores son un número entero entre \eqn{[1, 10]} el cual hace referencia
a diferentes temas disponibles en dicha librería (\code{ffx}, \code{google}, \code{tufte},
\code{538}, \code{ggplot2}, \code{economist}, \code{sandsignika}, \code{ft}, \code{superheroes} y \code{flatdark},
respectivamente). El tema por defecto, al no ingresar valor alguno, es
\code{hc_theme_flat()}.
\item \code{hc.Slider}: Si es \code{TRUE} agrega un deslizador/navegador dinámico en la
parte inferior de la serie. Proporciona herramientas para acercar y alejar
partes de la serie, así como para desplazarse por el conjunto de datos.
El valor por defecto es \code{FALSE}.
\item \code{hc.BoxInfo}: Si es \code{TRUE} (\emph{valor predeterminado}) la información
concerniente a cada punto se visualiza conjuntamente en un cuadro, o de
forma individual (\code{FALSE}) al pasar el cursor sobre él.
\item \code{hc.Credits}: Cadena de caracteres indicando un subtítulo o etiqueta de
créditos debajo del título principal.
\item \code{ply.LegendPosition}: Lista que especifica la posición y orientación de
la leyenda. Los valores por defecto la ubican centrada verticalmente a la
derecha del plot, es decir, \code{c(x = 1, y = 0.5, orientation = "v")}.
\item \code{ply.Interaction}: Cadena de caracteres que determina el modo de las
interacciones de desplazamiento. Los valores permitidos son \code{"x unified"}
(\emph{valor predeterminado}), \code{"y unified"}, \code{"closest"}, \code{"x"}, \code{"y"} y
\code{FALSE}.
\item \code{ply.Credits}: Lista que especifica la posición y texto para añadir un
subtítulo o etiqueta de créditos a la serie principal, por ejemplo,
\code{c(x = 0.2, y = 1, text = "https://...")}.
\item \code{dyg.LegendWidth}: Número que indica el ancho (\emph{en píxeles}) que
ocupará la leyenda. El valor por defecto es \code{250}.
\item \code{dyg.Resaltar}: Si es \code{FALSE} (\emph{valor predeterminado}) no se resaltará
la serie en que se sitúa el cursor.
\item \code{gg.Tema}: Modifica el tema con el cual se creará la serie. Los posibles
valores son un número entero entre \eqn{[1, 11]} el cual hace referencia
a diferentes temas disponibles para \code{ggplot2} (\code{theme_light}, \code{theme_bw},
\code{theme_classic}, \code{theme_linedraw}, \code{theme_gray}, \code{theme_hc}, \code{theme_pander},
\code{theme_gdocs}, \code{theme_fivethirtyeight}, \code{theme_economist} y \code{theme_solarized}
respectivamente).
El tema por defecto, al no ingresar valor alguno, es el construido por el
departamento \code{theme_DNPE}.
\item \code{gg.Legend}: Lista que especifica la posición y orientación de la leyenda.
Los valores por defecto la ubican verticalmente a la derecha del plot.
Algunos valores aceptados para \code{legend.position} son \code{"none"}, \code{"left"},
\code{"top"}, \code{"right"}, \code{"bottom"} y \code{c(CoordX, CoordY)}. Para \code{legend.direction}
solo se acepta \code{"vertical"} u \code{"horizontal"}.
\item \code{gg.Linea}: Una lista de parámetros admitidos por la función \link[ggplot2:geom_path]{geom_line()}).
\item \code{gg.Punto}: Una lista de parámetros admitidos por la función \link[ggplot2:geom_point]{geom_point()})
\item \code{gg.Texto}: Una lista cuyos valores admitidos y usados son \code{subtitle},
\code{caption} y \code{tag}.
\item \code{gg.Repel}: Una lista de parámetros admitidos por la función \link[ggrepel:geom_text_repel]{geom_text_repel()})
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna la serie (\emph{objeto widget de HTML}) creada. La clase del objeto retornado
será un "htmlwidget" y dependiendo de la librería usada pertenecerá adicionalmente
a la clase "highchart", "plotly" o "dygraphs".
}
\description{
Esta función proporciona excelentes herramientas y opciones para la visualización
de series de tiempo dinámicas con el objetivo de estudiar la evolución de una
o varias variables a lo largo del tiempo. Dicha serie interactiva se puede
representar usando tres diferentes librerías que son \code{Highcharter}, \code{Plotly}
y \code{Dygraph}, las cuales usan internamente \code{JavaScript}.
}
\details{
Al usar el paquete \code{Highcharter} y usar las opciones de descarga, el nombre del
archivo descargado será la concatenación del plot graficado y la categoría usada,
así, por ejemplo, si se graficó la serie de tiempo para la categoría "Sede" el
nombre será \code{PlotSeries_Sede.png}.

Tenga en cuenta que la librería \code{"dygraphs"} solo la podrá usar si dentro del
argumento tiempo ingresa las dos variables (\code{YEAR}, \code{SEMESTRE}) para asemejar
su estructura a los agregados clásicos. En caso contrario le arrojara un error.

Recuerde que puede usar más temas (\emph{cualquiera de hecho}) de los que se
proporcionan para \code{ggplot2}. Por ejemplo, los de \href{https://github.com/hrbrmstr/hrbrthemes}{hrbrthemes}
o \href{https://github.com/ricardo-bion/ggtech}{ggtech}.
}
\note{
A continuación, se consolida en una tabla amigable el listado, uso y disposición
de todas las opciones para el parámetro \code{estilo}, dependiendo del tipo de gráfico
(\emph{dinámico o estático}) y la librería usada (\emph{en el caso de que sea dinámico}).\tabular{ccccc}{
   \strong{PARÁMETRO} \tab \strong{VALOR} \tab \strong{PARÁMETRO} \tab \strong{VALOR} \tab \strong{PARÁMETRO} \cr
    \tab * \tab  \tab • \tab gg.Tema \cr
    \tab * \tab  \tab • \tab gg.Legend \cr
    \tab \emph{TRUE} \tab  \tab • \tab gg.Linea \cr
    \tab * \tab  \tab • \tab gg.Punto \cr
    \tab * \tab  \tab • \tab gg.Texto \cr
    \tab * \tab  \tab • \tab gg.Repel \cr
    \tab O \tab ~ \tab \emph{highcharter} \tab hc.Tema \cr
   \strong{estatico} \tab O \tab _ \tab ¦ \tab hc.BoxInfo \cr
    \tab O \tab _ \tab ¦ \tab hc.Slider \cr
    \tab O \tab _ \tab ¦ \tab hc.Credits \cr
    \tab \emph{FALSE} \tab \strong{libreria} \tab \emph{plotly} \tab ply.LegendPosition \cr
    \tab O \tab _ \tab ° \tab ply.Credits \cr
    \tab O \tab _ \tab ° \tab ply.Interaction \cr
    \tab O \tab _ \tab \emph{dygraphs} \tab dyg.LegendWidth \cr
    \tab O \tab ~ \tab L \tab dyg.Resaltar \cr
}
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
\dontshow{if (all(require("tibble"), require("dplyr"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# library("tibble"); library("dplyr")
set.seed(42)
Blood <- tibble(
  Year    = rep(2000:2001, each = 100),
  Quarter = sample(c("I", "II", "III", "IV"), size = 200, replace = TRUE),
  Week    = sample(c("1rt", "2nd", "3rd"), size = 200, replace = TRUE),
  Group   = sample(
    c("O", "A", "B", "AB"), size = 200, prob = c(.5, .3, .16, .4), replace = TRUE
  ),
  RH      = sample(c("+", "-"), size = 200, replace = TRUE),
  Prevalence = round(runif(200)*100)
)
Plot.Series(
  datos     = Blood,
  tiempo    = vars(Year, Quarter, Week),
  valores   = Prevalence,
  categoria = RH,
  labelX    = ""
)
Plot.Series(
  datos     = Blood,
  tiempo    = vars(Year, Quarter),
  valores   = Prevalence,
  categoria = Group,
  libreria  = "plotly"
)
# ---------------------------------------------------------------------------
misColores <- c(
  "#29ABE2", # AZUL CLARO  | Amazonia
  "#8CC63F", # VERDE       | Bogota
  "#CC241D", # ROJO        | Caribe
  "#0071BC", # AZUL VIVO   | Manizales
  "#F15A24", # NARANJA     | Medellin
  "#FBB03B", # AMARILLO    | Orinoquia
  "#93278F", # MORADO      | Palmira
  "#8A381A"  # GRIS        | Tumaco
)
Msj <- "Distribuci\u00f3n de estudiantes graduados (desde el 2009-I al 2021-I) por sede."
Txt <- "EVOLUCI\u00d3N DEL N\u00daMERO DE GRADUADOS POR SEDE"
Plot.Series(
  datos        = ejConsolidadoGrad,
  categoria    = "SEDE_NOMBRE_ADM",
  freqRelativa = TRUE,
  ylim         = c(0, 75),
  colores      = misColores,
  titulo       = Txt,
  labelY       = "Frecuencia Relativa<br>(\% de graduados)",
  libreria     = "highcharter",
  estilo       = list(LegendTitle = "SEDE:", hc.Tema = 10, hc.Slider = TRUE, hc.Credits = Msj)
)
# ---------------------------------------------------------------------------
Plot.Series(
  datos     = ejConsolidadoGrad,
  categoria = "SEDE_NOMBRE_ADM",
  invertir  = TRUE,
  colores   = misColores,
  titulo    = Txt,
  labelY    = "N\u00famero de Graduados",
  libreria  = "plotly",
  estilo    = list(
    LegendTitle = "SEDE:", ply.Interaction = "closest",
    ply.LegendPosition = list(x = 0.16, y = -0.25, orientation = "h"),
    ply.Credits = list(x = 0.5, y = 0.1, text = Msj)
  )
)
# ---------------------------------------------------------------------------
Plot.Series(
  datos     = ejConsolidadoGrad,
  categoria = "SEDE_NOMBRE_ADM",
  colores   = misColores,
  titulo    = Txt,
  labelY    = "N\u00famero de Graduados (k: miles)",
  libreria  = "dygraphs",
  estilo    = list(dyg.LegendWidth = 650, dyg.Resaltar = TRUE)
)
\dontshow{\}) # examplesIf}
\dontshow{if (require("dplyr")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ---------------------------------------------------------------------------
# Agrupando para eliminar el semestre
# library("dplyr")
df <- ejConsolidadoGrad |> group_by(Variable, YEAR, Clase) |>
  summarise(Total = sum(Total, na.rm = TRUE), .groups = "drop")

Msj <- "Comportamiento anual, considerando ambos semestres (exceptuando el caso del 2021)."
Plot.Series(
  datos     = df,
  categoria = "SEXO",
  ylim      = c(1000, 6000),
  colores   = c("#3360FF", "#F30081"),
  titulo    = "EVOLUCI\u00d3N DEL N\u00daMERO DE GRADUADOS POR SEXO",
  labelX    = "A\u00f1o",
  labelY    = "N\u00famero de Graduados",
  libreria  = "highcharter",
  estilo    = list(hc.Tema = 1, hc.Credits = Msj)
)
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (ggplot2)
# library("magick"); library("cowplot")
txtA <- "EVOLUCI\u00d3N DEL N.\u00ba DE GRADUADOS \u00d7 SEDE"
txtB <- "\nComportamiento anual (exceptuando el caso del 2021)."
fig1 <- Plot.Series(
  datos        = ejConsolidadoGrad,
  categoria    = "SEDE_NOMBRE_ADM",
  freqRelativa = FALSE,
  invertir     = FALSE,
  ylim         = c(100, 2000),
  colores      = misColores,
  titulo       = txtA,
  labelY       = "N\u00famero de Graduados",
  estatico     = TRUE,
  estilo       = list(
    LegendTitle = "SEDE:", gg.Tema = 8,
    gg.Legend = list(legend.position = "bottom", legend.direction = "horizontal"),
    gg.Linea  = list(linetype = 2, size = 0.1, arrow = grid::arrow()),
    gg.Punto  = list(alpha = 0.2, shape = 21, size = 2, stroke = 5),
    gg.Texto  = list(
      subtitle = txtB, caption = "\t\t Informaci\u00f3n Disponible desde 2009-1", tag = "\u00ae"
    )
  )
)
# A continuación, se detalla el caso en el que quiera adicionar un logo a 'fig1'
# library("ggplot2"); library("magick"); require("cowplot")
URL <- "https://upload.wikimedia.org/wikipedia/commons/1/1e/UNAL_Logosimbolo.svg"
LogoUN <- magick::image_read_svg(URL)
ggdraw() +
  draw_image(LogoUN, scale = 0.15, x = 0.15, hjust = 1, halign = 1, valign = 0) +
  draw_plot(fig1 + theme(legend.background = element_blank(),
                         panel.background = element_blank(),
                         plot.background = element_blank()
                         )
  )
\dontshow{\}) # examplesIf}
\dontshow{if (all(require("ggplot2"), require("ggrepel"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ---------------------------------------------------------------------------
# A continuación, se detalla el caso en el que quiera anotaciones textuales repulsivas
#   * (1) Espacio vacío que se debe respetar alrededor de la caja delimitadora
#   * (2) Espacio vacío que se debe respetar alrededor de cada punto
#   * (3) Entre más bajo más flechas, entre más distancia menos flechas
Plot.Series(
  datos        = ejConsolidadoGrad,
  categoria    = "SEDE_NOMBRE_ADM",
  freqRelativa = FALSE,
  invertir     = FALSE,
  ylim         = c(100, 2000),
  colores      = misColores,
  titulo       = "EVOLUCI\u00d3N DEL N.\u00ba DE GRADUADOS \u00d7 SEDE",
  labelY       = "N\u00famero de Graduados",
  estatico     = TRUE,
  estilo       = list(
    gg.Tema  = 1,
    gg.Repel = list(
      direction = "both", seed = 42, nudge_y = 0.25,
      arrow = arrow(length = unit(0.01, "npc")), segment.colour = "#4C716B",
      box.padding   = 0.5 ,     # (1)
      point.padding = 0.25,     # (2)
      min.segment.length = 0.45 # (3)
    )
  )
)
\dontshow{\}) # examplesIf}
}
