// Generated by rstantools.  Do not edit by hand.

/*
    TriDimRegression is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TriDimRegression is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TriDimRegression.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_tridim_transformation_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 44, column 2 to column 22)",
                                                      " (in 'string', line 45, column 2 to column 22)",
                                                      " (in 'string', line 47, column 2 to column 22)",
                                                      " (in 'string', line 50, column 2 to column 26)",
                                                      " (in 'string', line 52, column 2 to column 33)",
                                                      " (in 'string', line 115, column 6 to line 118, column 39)",
                                                      " (in 'string', line 114, column 38 to line 119, column 5)",
                                                      " (in 'string', line 114, column 9 to line 119, column 5)",
                                                      " (in 'string', line 109, column 6 to line 112, column 35)",
                                                      " (in 'string', line 108, column 33 to line 113, column 5)",
                                                      " (in 'string', line 108, column 9 to line 119, column 5)",
                                                      " (in 'string', line 101, column 6 to column 15)",
                                                      " (in 'string', line 102, column 6 to column 44)",
                                                      " (in 'string', line 103, column 6 to line 106, column 35)",
                                                      " (in 'string', line 100, column 38 to line 107, column 5)",
                                                      " (in 'string', line 100, column 9 to line 119, column 5)",
                                                      " (in 'string', line 93, column 6 to column 15)",
                                                      " (in 'string', line 94, column 6 to column 44)",
                                                      " (in 'string', line 95, column 6 to line 98, column 35)",
                                                      " (in 'string', line 92, column 38 to line 99, column 5)",
                                                      " (in 'string', line 92, column 9 to line 119, column 5)",
                                                      " (in 'string', line 85, column 6 to column 15)",
                                                      " (in 'string', line 86, column 6 to column 44)",
                                                      " (in 'string', line 87, column 6 to line 90, column 35)",
                                                      " (in 'string', line 84, column 38 to line 91, column 5)",
                                                      " (in 'string', line 84, column 9 to line 119, column 5)",
                                                      " (in 'string', line 79, column 6 to line 82, column 35)",
                                                      " (in 'string', line 78, column 33 to line 83, column 5)",
                                                      " (in 'string', line 78, column 4 to line 119, column 5)",
                                                      " (in 'string', line 76, column 7 to line 120, column 3)",
                                                      " (in 'string', line 71, column 6 to line 73, column 32)",
                                                      " (in 'string', line 70, column 38 to line 74, column 5)",
                                                      " (in 'string', line 70, column 9 to line 74, column 5)",
                                                      " (in 'string', line 66, column 6 to line 68, column 29)",
                                                      " (in 'string', line 65, column 34 to line 69, column 5)",
                                                      " (in 'string', line 65, column 9 to line 74, column 5)",
                                                      " (in 'string', line 61, column 6 to line 63, column 29)",
                                                      " (in 'string', line 60, column 36 to line 64, column 5)",
                                                      " (in 'string', line 60, column 9 to line 74, column 5)",
                                                      " (in 'string', line 56, column 6 to line 58, column 29)",
                                                      " (in 'string', line 55, column 33 to line 59, column 5)",
                                                      " (in 'string', line 55, column 4 to line 74, column 5)",
                                                      " (in 'string', line 53, column 17 to line 75, column 3)",
                                                      " (in 'string', line 53, column 2 to line 120, column 3)",
                                                      " (in 'string', line 122, column 2 to column 60)",
                                                      " (in 'string', line 135, column 2 to column 24)",
                                                      " (in 'string', line 137, column 4 to column 20)",
                                                      " (in 'string', line 139, column 6 to column 97)",
                                                      " (in 'string', line 138, column 22 to line 140, column 5)",
                                                      " (in 'string', line 138, column 4 to line 140, column 5)",
                                                      " (in 'string', line 136, column 20 to line 141, column 3)",
                                                      " (in 'string', line 136, column 2 to line 141, column 3)",
                                                      " (in 'string', line 126, column 2 to column 70)",
                                                      " (in 'string', line 128, column 2 to column 35)",
                                                      " (in 'string', line 129, column 2 to column 37)",
                                                      " (in 'string', line 131, column 4 to column 39)",
                                                      " (in 'string', line 130, column 31 to line 132, column 3)",
                                                      " (in 'string', line 130, column 2 to line 132, column 3)",
                                                      " (in 'string', line 2, column 2 to column 34)",
                                                      " (in 'string', line 3, column 2 to column 21)",
                                                      " (in 'string', line 4, column 2 to column 21)",
                                                      " (in 'string', line 5, column 2 to column 21)",
                                                      " (in 'string', line 6, column 9 to column 14)",
                                                      " (in 'string', line 6, column 16 to column 21)",
                                                      " (in 'string', line 6, column 2 to column 26)",
                                                      " (in 'string', line 7, column 9 to column 14)",
                                                      " (in 'string', line 7, column 16 to column 21)",
                                                      " (in 'string', line 7, column 2 to column 26)",
                                                      " (in 'string', line 8, column 18 to column 23)",
                                                      " (in 'string', line 8, column 2 to column 31)",
                                                      " (in 'string', line 10, column 2 to column 24)",
                                                      " (in 'string', line 11, column 2 to column 24)",
                                                      " (in 'string', line 12, column 2 to column 28)",
                                                      " (in 'string', line 15, column 2 to column 28)",
                                                      " (in 'string', line 17, column 2 to column 22)",
                                                      " (in 'string', line 18, column 2 to column 20)",
                                                      " (in 'string', line 19, column 2 to column 17)",
                                                      " (in 'string', line 20, column 2 to column 21)",
                                                      " (in 'string', line 21, column 2 to column 22)",
                                                      " (in 'string', line 22, column 2 to column 22)",
                                                      " (in 'string', line 23, column 2 to column 22)",
                                                      " (in 'string', line 25, column 9 to column 14)",
                                                      " (in 'string', line 25, column 2 to column 24)",
                                                      " (in 'string', line 26, column 9 to column 14)",
                                                      " (in 'string', line 26, column 2 to column 24)",
                                                      " (in 'string', line 27, column 9 to column 14)",
                                                      " (in 'string', line 27, column 2 to column 27)",
                                                      " (in 'string', line 29, column 9 to column 14)",
                                                      " (in 'string', line 29, column 16 to column 23)",
                                                      " (in 'string', line 29, column 2 to column 29)",
                                                      " (in 'string', line 31, column 2 to column 26)",
                                                      " (in 'string', line 32, column 2 to column 26)",
                                                      " (in 'string', line 33, column 2 to column 51)",
                                                      " (in 'string', line 37, column 6 to column 31)",
                                                      " (in 'string', line 36, column 23 to line 38, column 5)",
                                                      " (in 'string', line 36, column 4 to line 38, column 5)",
                                                      " (in 'string', line 39, column 4 to column 25)",
                                                      " (in 'string', line 35, column 20 to line 40, column 3)",
                                                      " (in 'string', line 35, column 2 to line 40, column 3)",
                                                      " (in 'string', line 44, column 8 to column 13)",
                                                      " (in 'string', line 45, column 8 to column 13)",
                                                      " (in 'string', line 50, column 9 to column 14)",
                                                      " (in 'string', line 52, column 9 to column 18)",
                                                      " (in 'string', line 52, column 20 to column 29)",
                                                      " (in 'string', line 135, column 9 to column 14)"};
#include <stan_meta_header.hpp>
class model_tridim_transformation final : public model_base_crtp<model_tridim_transformation> {
private:
  int transform;
  int rowsN;
  int varsN;
  int betaN;
  Eigen::Matrix<double, -1, -1> dv;
  Eigen::Matrix<double, -1, -1> iv;
  Eigen::Matrix<double, -1, 1> dv_sd;
  std::vector<double> a_prior;
  std::vector<double> b_prior;
  double sigma_prior;
  int longN;
  int TRANSLATION;
  int EUCLIDEAN;
  int AFFINE;
  int PROJECTIVE;
  int EUCLIDEAN_X;
  int EUCLIDEAN_y;
  int EUCLIDEAN_z;
  Eigen::Matrix<double, -1, 1> dv_long;
  Eigen::Matrix<double, -1, 1> iv_long;
  Eigen::Matrix<double, -1, 1> dv_sd_long;
  Eigen::Matrix<double, -1, -1> ivH;
  int M_1dim__;
  int M_2dim__;
 
public:
  ~model_tridim_transformation() { }
  
  inline std::string model_name() const final { return "model_tridim_transformation"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_tridim_transformation(stan::io::var_context& context__,
                              unsigned int random_seed__ = 0,
                              std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_tridim_transformation_namespace::model_tridim_transformation";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 59;
      context__.validate_dims("data initialization","transform","int",
          context__.to_vec());
      transform = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      transform = context__.vals_i("transform")[(1 - 1)];
      current_statement__ = 59;
      current_statement__ = 59;
      check_greater_or_equal(function__, "transform", transform, 0);
      current_statement__ = 59;
      current_statement__ = 59;
      check_less_or_equal(function__, "transform", transform, 6);
      current_statement__ = 60;
      context__.validate_dims("data initialization","rowsN","int",
          context__.to_vec());
      rowsN = std::numeric_limits<int>::min();
      
      current_statement__ = 60;
      rowsN = context__.vals_i("rowsN")[(1 - 1)];
      current_statement__ = 60;
      current_statement__ = 60;
      check_greater_or_equal(function__, "rowsN", rowsN, 1);
      current_statement__ = 61;
      context__.validate_dims("data initialization","varsN","int",
          context__.to_vec());
      varsN = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      varsN = context__.vals_i("varsN")[(1 - 1)];
      current_statement__ = 61;
      current_statement__ = 61;
      check_greater_or_equal(function__, "varsN", varsN, 1);
      current_statement__ = 62;
      context__.validate_dims("data initialization","betaN","int",
          context__.to_vec());
      betaN = std::numeric_limits<int>::min();
      
      current_statement__ = 62;
      betaN = context__.vals_i("betaN")[(1 - 1)];
      current_statement__ = 62;
      current_statement__ = 62;
      check_greater_or_equal(function__, "betaN", betaN, 0);
      current_statement__ = 63;
      validate_non_negative_index("dv", "rowsN", rowsN);
      current_statement__ = 64;
      validate_non_negative_index("dv", "varsN", varsN);
      current_statement__ = 65;
      context__.validate_dims("data initialization","dv","double",
          context__.to_vec(rowsN, varsN));
      dv = Eigen::Matrix<double, -1, -1>(rowsN, varsN);
      stan::math::fill(dv, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dv_flat__;
        current_statement__ = 65;
        assign(dv_flat__, nil_index_list(), context__.vals_r("dv"),
          "assigning variable dv_flat__");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
          current_statement__ = 65;
          for (int sym2__ = 1; sym2__ <= rowsN; ++sym2__) {
            current_statement__ = 65;
            assign(dv,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              dv_flat__[(pos__ - 1)], "assigning variable dv");
            current_statement__ = 65;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 66;
      validate_non_negative_index("iv", "rowsN", rowsN);
      current_statement__ = 67;
      validate_non_negative_index("iv", "varsN", varsN);
      current_statement__ = 68;
      context__.validate_dims("data initialization","iv","double",
          context__.to_vec(rowsN, varsN));
      iv = Eigen::Matrix<double, -1, -1>(rowsN, varsN);
      stan::math::fill(iv, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> iv_flat__;
        current_statement__ = 68;
        assign(iv_flat__, nil_index_list(), context__.vals_r("iv"),
          "assigning variable iv_flat__");
        current_statement__ = 68;
        pos__ = 1;
        current_statement__ = 68;
        for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
          current_statement__ = 68;
          for (int sym2__ = 1; sym2__ <= rowsN; ++sym2__) {
            current_statement__ = 68;
            assign(iv,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              iv_flat__[(pos__ - 1)], "assigning variable iv");
            current_statement__ = 68;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 69;
      validate_non_negative_index("dv_sd", "varsN", varsN);
      current_statement__ = 70;
      context__.validate_dims("data initialization","dv_sd","double",
          context__.to_vec(varsN));
      dv_sd = Eigen::Matrix<double, -1, 1>(varsN);
      stan::math::fill(dv_sd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> dv_sd_flat__;
        current_statement__ = 70;
        assign(dv_sd_flat__, nil_index_list(), context__.vals_r("dv_sd"),
          "assigning variable dv_sd_flat__");
        current_statement__ = 70;
        pos__ = 1;
        current_statement__ = 70;
        for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
          current_statement__ = 70;
          assign(dv_sd, cons_list(index_uni(sym1__), nil_index_list()),
            dv_sd_flat__[(pos__ - 1)], "assigning variable dv_sd");
          current_statement__ = 70;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 70;
      for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
        current_statement__ = 70;
        current_statement__ = 70;
        check_greater_or_equal(function__, "dv_sd[sym1__]",
                               dv_sd[(sym1__ - 1)], 0);}
      current_statement__ = 71;
      context__.validate_dims("data initialization","a_prior","double",
          context__.to_vec(2));
      a_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 71;
      assign(a_prior, nil_index_list(), context__.vals_r("a_prior"),
        "assigning variable a_prior");
      current_statement__ = 72;
      context__.validate_dims("data initialization","b_prior","double",
          context__.to_vec(2));
      b_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 72;
      assign(b_prior, nil_index_list(), context__.vals_r("b_prior"),
        "assigning variable b_prior");
      current_statement__ = 73;
      context__.validate_dims("data initialization","sigma_prior","double",
          context__.to_vec());
      sigma_prior = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 73;
      sigma_prior = context__.vals_r("sigma_prior")[(1 - 1)];
      current_statement__ = 73;
      current_statement__ = 73;
      check_greater_or_equal(function__, "sigma_prior", sigma_prior, 0);
      current_statement__ = 74;
      longN = std::numeric_limits<int>::min();
      
      current_statement__ = 74;
      longN = (rowsN * varsN);
      current_statement__ = 75;
      TRANSLATION = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      TRANSLATION = 0;
      current_statement__ = 76;
      EUCLIDEAN = std::numeric_limits<int>::min();
      
      current_statement__ = 76;
      EUCLIDEAN = 1;
      current_statement__ = 77;
      AFFINE = std::numeric_limits<int>::min();
      
      current_statement__ = 77;
      AFFINE = 2;
      current_statement__ = 78;
      PROJECTIVE = std::numeric_limits<int>::min();
      
      current_statement__ = 78;
      PROJECTIVE = 3;
      current_statement__ = 79;
      EUCLIDEAN_X = std::numeric_limits<int>::min();
      
      current_statement__ = 79;
      EUCLIDEAN_X = 4;
      current_statement__ = 80;
      EUCLIDEAN_y = std::numeric_limits<int>::min();
      
      current_statement__ = 80;
      EUCLIDEAN_y = 5;
      current_statement__ = 81;
      EUCLIDEAN_z = std::numeric_limits<int>::min();
      
      current_statement__ = 81;
      EUCLIDEAN_z = 6;
      current_statement__ = 82;
      validate_non_negative_index("dv_long", "longN", longN);
      current_statement__ = 83;
      dv_long = Eigen::Matrix<double, -1, 1>(longN);
      stan::math::fill(dv_long, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 84;
      validate_non_negative_index("iv_long", "longN", longN);
      current_statement__ = 85;
      iv_long = Eigen::Matrix<double, -1, 1>(longN);
      stan::math::fill(iv_long, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 86;
      validate_non_negative_index("dv_sd_long", "longN", longN);
      current_statement__ = 87;
      dv_sd_long = Eigen::Matrix<double, -1, 1>(longN);
      stan::math::fill(dv_sd_long, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 88;
      validate_non_negative_index("ivH", "rowsN", rowsN);
      current_statement__ = 89;
      validate_non_negative_index("ivH", "varsN + 1", (varsN + 1));
      current_statement__ = 90;
      ivH = Eigen::Matrix<double, -1, -1>(rowsN, (varsN + 1));
      stan::math::fill(ivH, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 91;
      assign(dv_long, nil_index_list(), to_vector(dv),
        "assigning variable dv_long");
      current_statement__ = 92;
      assign(iv_long, nil_index_list(), to_vector(iv),
        "assigning variable iv_long");
      current_statement__ = 93;
      assign(dv_sd_long, nil_index_list(),
        to_vector(rep_matrix(dv_sd, rowsN)), "assigning variable dv_sd_long");
      current_statement__ = 99;
      for (int iR = 1; iR <= rowsN; ++iR) {
        current_statement__ = 96;
        for (int iV = 1; iV <= varsN; ++iV) {
          current_statement__ = 94;
          assign(ivH,
            cons_list(index_uni(iR),
              cons_list(index_uni(iV), nil_index_list())),
            rvalue(iv,
              cons_list(index_uni(iR),
                cons_list(index_uni(iV), nil_index_list())), "iv"),
            "assigning variable ivH");}
        current_statement__ = 97;
        assign(ivH,
          cons_list(index_uni(iR),
            cons_list(index_uni((varsN + 1)), nil_index_list())), 1,
          "assigning variable ivH");}
      current_statement__ = 100;
      validate_non_negative_index("a", "varsN", varsN);
      current_statement__ = 101;
      validate_non_negative_index("b", "betaN", betaN);
      current_statement__ = 102;
      validate_non_negative_index("predicted", "longN", longN);
      current_statement__ = 103;
      M_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 103;
      M_1dim__ = (varsN + 1);
      current_statement__ = 103;
      validate_non_negative_index("M", "varsN + 1", M_1dim__);
      current_statement__ = 104;
      M_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 104;
      M_2dim__ = (varsN + 1);
      current_statement__ = 104;
      validate_non_negative_index("M", "varsN + 1", M_2dim__);
      current_statement__ = 105;
      validate_non_negative_index("log_lik", "rowsN", rowsN);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += varsN;
      num_params_r__ += betaN;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_tridim_transformation_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> a;
      a = std::vector<local_scalar_t__>(varsN, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
        current_statement__ = 1;
        assign(a, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable a");}
      std::vector<local_scalar_t__> b;
      b = std::vector<local_scalar_t__>(betaN, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= betaN; ++sym1__) {
        current_statement__ = 2;
        assign(b, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable b");}
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 3;
      sigma = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 3;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> predicted;
      predicted = Eigen::Matrix<local_scalar_t__, -1, 1>(longN);
      stan::math::fill(predicted, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> M;
      M = Eigen::Matrix<local_scalar_t__, -1, -1>(M_1dim__, M_2dim__);
      stan::math::fill(M, DUMMY_VAR__);
      
      current_statement__ = 44;
      if (logical_eq(varsN, 2)) {
        current_statement__ = 42;
        if (logical_eq(transform, TRANSLATION)) {
          current_statement__ = 40;
          assign(M, nil_index_list(), stan::math::to_matrix(
            std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
            (Eigen::Matrix<double,1,-1>(3) << 1, 0, 0).finished(),
            (Eigen::Matrix<double,1,-1>(3) << 0, 1, 0).finished(),
            (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
            a[(2 - 1)], 1).finished()}), "assigning variable M");
        } else {
          current_statement__ = 39;
          if (logical_eq(transform, EUCLIDEAN)) {
            current_statement__ = 37;
            assign(M, nil_index_list(), stan::math::to_matrix(
              std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(1 - 1)],
              -b[(2 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(2 - 1)],
              b[(1 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
              a[(2 - 1)], 1).finished()}), "assigning variable M");
          } else {
            current_statement__ = 36;
            if (logical_eq(transform, AFFINE)) {
              current_statement__ = 34;
              assign(M, nil_index_list(), stan::math::to_matrix(
                std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(1 - 1)],
                b[(3 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(2 - 1)],
                b[(4 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
                a[(2 - 1)], 1).finished()}), "assigning variable M");
            } else {
              current_statement__ = 33;
              if (logical_eq(transform, PROJECTIVE)) {
                current_statement__ = 31;
                assign(M, nil_index_list(), stan::math::to_matrix(
                  std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                  (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(1 - 1)],
                  b[(3 - 1)], b[(5 - 1)]).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(2 - 1)],
                  b[(4 - 1)], b[(6 - 1)]).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
                  a[(2 - 1)], 1).finished()}), "assigning variable M");
              } 
            }
          }
        }
      } else {
        current_statement__ = 29;
        if (logical_eq(transform, TRANSLATION)) {
          current_statement__ = 27;
          assign(M, nil_index_list(), stan::math::to_matrix(
            std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
            (Eigen::Matrix<double,1,-1>(4) << 1, 0, 0, 0).finished(),
            (Eigen::Matrix<double,1,-1>(4) << 0, 1, 0, 0).finished(),
            (Eigen::Matrix<double,1,-1>(4) << 0, 0, 1, 0).finished(),
            (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
            a[(2 - 1)], a[(3 - 1)], 1).finished()}), "assigning variable M");
        } else {
          current_statement__ = 26;
          if (logical_eq(transform, EUCLIDEAN_X)) {
            local_scalar_t__ phi;
            phi = DUMMY_VAR__;
            
            current_statement__ = 23;
            phi = stan::math::sqrt(
                    ((b[(1 - 1)] * b[(1 - 1)]) + (b[(2 - 1)] * b[(2 - 1)])));
            current_statement__ = 24;
            assign(M, nil_index_list(), stan::math::to_matrix(
              std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
              (Eigen::Matrix<local_scalar_t__,1,-1>(4) << phi, 0, 0,
              0).finished(), (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0,
              b[(1 - 1)], b[(2 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0, -b[(2 - 1)],
              b[(1 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
              a[(2 - 1)], a[(3 - 1)], 1).finished()}), "assigning variable M");
          } else {
            current_statement__ = 21;
            if (logical_eq(transform, EUCLIDEAN_y)) {
              local_scalar_t__ phi;
              phi = DUMMY_VAR__;
              
              current_statement__ = 18;
              phi = stan::math::sqrt(
                      ((b[(1 - 1)] * b[(1 - 1)]) + (b[(2 - 1)] * b[(2 - 1)])));
              current_statement__ = 19;
              assign(M, nil_index_list(), stan::math::to_matrix(
                std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)], 0,
                -b[(2 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0, phi, 0,
                0).finished(), (Eigen::Matrix<local_scalar_t__,1,-1>(4) <<
                b[(2 - 1)], 0, b[(1 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
                a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                "assigning variable M");
            } else {
              current_statement__ = 16;
              if (logical_eq(transform, EUCLIDEAN_z)) {
                local_scalar_t__ phi;
                phi = DUMMY_VAR__;
                
                current_statement__ = 13;
                phi = stan::math::sqrt(
                        ((b[(1 - 1)] * b[(1 - 1)]) +
                          (b[(2 - 1)] * b[(2 - 1)])));
                current_statement__ = 14;
                assign(M, nil_index_list(), stan::math::to_matrix(
                  std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                  (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)],
                  b[(2 - 1)], 0, 0).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(4) << -b[(2 - 1)],
                  b[(1 - 1)], 0, 0).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0, 0, phi,
                  0).finished(), (Eigen::Matrix<local_scalar_t__,1,-1>(4) <<
                  a[(1 - 1)], a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                  "assigning variable M");
              } else {
                current_statement__ = 11;
                if (logical_eq(transform, AFFINE)) {
                  current_statement__ = 9;
                  assign(M, nil_index_list(), stan::math::to_matrix(
                    std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)],
                    b[(4 - 1)], b[(7 - 1)], 0).finished(),
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(2 - 1)],
                    b[(5 - 1)], b[(8 - 1)], 0).finished(),
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(3 - 1)],
                    b[(6 - 1)], b[(9 - 1)], 0).finished(),
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
                    a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                    "assigning variable M");
                } else {
                  current_statement__ = 8;
                  if (logical_eq(transform, PROJECTIVE)) {
                    current_statement__ = 6;
                    assign(M, nil_index_list(), stan::math::to_matrix(
                      std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)],
                      b[(4 - 1)], b[(7 - 1)], b[(10 - 1)]).finished(),
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(2 - 1)],
                      b[(5 - 1)], b[(8 - 1)], b[(11 - 1)]).finished(),
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(3 - 1)],
                      b[(6 - 1)], b[(9 - 1)], b[(12 - 1)]).finished(),
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
                      a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                      "assigning variable M");
                  } 
                }
              }
            }
          }
        }
      }
      current_statement__ = 45;
      assign(predicted, nil_index_list(),
        to_vector(block(multiply(ivH, M), 1, 1, rowsN, varsN)),
        "assigning variable predicted");
      {
        current_statement__ = 53;
        lp_accum__.add(
          normal_lpdf<propto__>(dv_long, predicted,
            elt_multiply(dv_sd_long, rep_vector(sigma, longN))));
        current_statement__ = 54;
        lp_accum__.add(exponential_lpdf<propto__>(sigma, sigma_prior));
        current_statement__ = 55;
        lp_accum__.add(
          normal_lpdf<propto__>(a, a_prior[(1 - 1)], a_prior[(2 - 1)]));
        current_statement__ = 58;
        if (logical_neq(transform, TRANSLATION)) {
          current_statement__ = 56;
          lp_accum__.add(
            normal_lpdf<propto__>(b, b_prior[(1 - 1)], b_prior[(2 - 1)]));
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_tridim_transformation_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> a;
      a = std::vector<double>(varsN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
        current_statement__ = 1;
        assign(a, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable a");}
      std::vector<double> b;
      b = std::vector<double>(betaN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= betaN; ++sym1__) {
        current_statement__ = 2;
        assign(b, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable b");}
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma = in__.scalar();
      current_statement__ = 3;
      sigma = stan::math::lb_constrain(sigma, 0);
      Eigen::Matrix<double, -1, 1> predicted;
      predicted = Eigen::Matrix<double, -1, 1>(longN);
      stan::math::fill(predicted, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> M;
      M = Eigen::Matrix<double, -1, -1>(M_1dim__, M_2dim__);
      stan::math::fill(M, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
        vars__.emplace_back(a[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= betaN; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      vars__.emplace_back(sigma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 44;
      if (logical_eq(varsN, 2)) {
        current_statement__ = 42;
        if (logical_eq(transform, TRANSLATION)) {
          current_statement__ = 40;
          assign(M, nil_index_list(), stan::math::to_matrix(
            std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
            (Eigen::Matrix<double,1,-1>(3) << 1, 0, 0).finished(),
            (Eigen::Matrix<double,1,-1>(3) << 0, 1, 0).finished(),
            (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
            a[(2 - 1)], 1).finished()}), "assigning variable M");
        } else {
          current_statement__ = 39;
          if (logical_eq(transform, EUCLIDEAN)) {
            current_statement__ = 37;
            assign(M, nil_index_list(), stan::math::to_matrix(
              std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(1 - 1)],
              -b[(2 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(2 - 1)],
              b[(1 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
              a[(2 - 1)], 1).finished()}), "assigning variable M");
          } else {
            current_statement__ = 36;
            if (logical_eq(transform, AFFINE)) {
              current_statement__ = 34;
              assign(M, nil_index_list(), stan::math::to_matrix(
                std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(1 - 1)],
                b[(3 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(2 - 1)],
                b[(4 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
                a[(2 - 1)], 1).finished()}), "assigning variable M");
            } else {
              current_statement__ = 33;
              if (logical_eq(transform, PROJECTIVE)) {
                current_statement__ = 31;
                assign(M, nil_index_list(), stan::math::to_matrix(
                  std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                  (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(1 - 1)],
                  b[(3 - 1)], b[(5 - 1)]).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(3) << b[(2 - 1)],
                  b[(4 - 1)], b[(6 - 1)]).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(3) << a[(1 - 1)],
                  a[(2 - 1)], 1).finished()}), "assigning variable M");
              } 
            }
          }
        }
      } else {
        current_statement__ = 29;
        if (logical_eq(transform, TRANSLATION)) {
          current_statement__ = 27;
          assign(M, nil_index_list(), stan::math::to_matrix(
            std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
            (Eigen::Matrix<double,1,-1>(4) << 1, 0, 0, 0).finished(),
            (Eigen::Matrix<double,1,-1>(4) << 0, 1, 0, 0).finished(),
            (Eigen::Matrix<double,1,-1>(4) << 0, 0, 1, 0).finished(),
            (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
            a[(2 - 1)], a[(3 - 1)], 1).finished()}), "assigning variable M");
        } else {
          current_statement__ = 26;
          if (logical_eq(transform, EUCLIDEAN_X)) {
            double phi;
            phi = std::numeric_limits<double>::quiet_NaN();
            
            current_statement__ = 23;
            phi = stan::math::sqrt(
                    ((b[(1 - 1)] * b[(1 - 1)]) + (b[(2 - 1)] * b[(2 - 1)])));
            current_statement__ = 24;
            assign(M, nil_index_list(), stan::math::to_matrix(
              std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
              (Eigen::Matrix<local_scalar_t__,1,-1>(4) << phi, 0, 0,
              0).finished(), (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0,
              b[(1 - 1)], b[(2 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0, -b[(2 - 1)],
              b[(1 - 1)], 0).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
              a[(2 - 1)], a[(3 - 1)], 1).finished()}), "assigning variable M");
          } else {
            current_statement__ = 21;
            if (logical_eq(transform, EUCLIDEAN_y)) {
              double phi;
              phi = std::numeric_limits<double>::quiet_NaN();
              
              current_statement__ = 18;
              phi = stan::math::sqrt(
                      ((b[(1 - 1)] * b[(1 - 1)]) + (b[(2 - 1)] * b[(2 - 1)])));
              current_statement__ = 19;
              assign(M, nil_index_list(), stan::math::to_matrix(
                std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)], 0,
                -b[(2 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0, phi, 0,
                0).finished(), (Eigen::Matrix<local_scalar_t__,1,-1>(4) <<
                b[(2 - 1)], 0, b[(1 - 1)], 0).finished(),
                (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
                a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                "assigning variable M");
            } else {
              current_statement__ = 16;
              if (logical_eq(transform, EUCLIDEAN_z)) {
                double phi;
                phi = std::numeric_limits<double>::quiet_NaN();
                
                current_statement__ = 13;
                phi = stan::math::sqrt(
                        ((b[(1 - 1)] * b[(1 - 1)]) +
                          (b[(2 - 1)] * b[(2 - 1)])));
                current_statement__ = 14;
                assign(M, nil_index_list(), stan::math::to_matrix(
                  std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                  (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)],
                  b[(2 - 1)], 0, 0).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(4) << -b[(2 - 1)],
                  b[(1 - 1)], 0, 0).finished(),
                  (Eigen::Matrix<local_scalar_t__,1,-1>(4) << 0, 0, phi,
                  0).finished(), (Eigen::Matrix<local_scalar_t__,1,-1>(4) <<
                  a[(1 - 1)], a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                  "assigning variable M");
              } else {
                current_statement__ = 11;
                if (logical_eq(transform, AFFINE)) {
                  current_statement__ = 9;
                  assign(M, nil_index_list(), stan::math::to_matrix(
                    std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)],
                    b[(4 - 1)], b[(7 - 1)], 0).finished(),
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(2 - 1)],
                    b[(5 - 1)], b[(8 - 1)], 0).finished(),
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(3 - 1)],
                    b[(6 - 1)], b[(9 - 1)], 0).finished(),
                    (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
                    a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                    "assigning variable M");
                } else {
                  current_statement__ = 8;
                  if (logical_eq(transform, PROJECTIVE)) {
                    current_statement__ = 6;
                    assign(M, nil_index_list(), stan::math::to_matrix(
                      std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(1 - 1)],
                      b[(4 - 1)], b[(7 - 1)], b[(10 - 1)]).finished(),
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(2 - 1)],
                      b[(5 - 1)], b[(8 - 1)], b[(11 - 1)]).finished(),
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << b[(3 - 1)],
                      b[(6 - 1)], b[(9 - 1)], b[(12 - 1)]).finished(),
                      (Eigen::Matrix<local_scalar_t__,1,-1>(4) << a[(1 - 1)],
                      a[(2 - 1)], a[(3 - 1)], 1).finished()}),
                      "assigning variable M");
                  } 
                }
              }
            }
          }
        }
      }
      current_statement__ = 45;
      assign(predicted, nil_index_list(),
        to_vector(block(multiply(ivH, M), 1, 1, rowsN, varsN)),
        "assigning variable predicted");
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= longN; ++sym1__) {
          vars__.emplace_back(predicted[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= M_2dim__; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= M_1dim__; ++sym2__) {
            vars__.emplace_back(
              rvalue(M,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "M"));}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(rowsN);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 52;
      for (int iR = 1; iR <= rowsN; ++iR) {
        current_statement__ = 47;
        assign(log_lik, cons_list(index_uni(iR), nil_index_list()), 0,
          "assigning variable log_lik");
        current_statement__ = 50;
        for (int iV = 1; iV <= varsN; ++iV) {
          current_statement__ = 48;
          assign(log_lik, cons_list(index_uni(iR), nil_index_list()),
            (log_lik[(iR - 1)] +
              normal_lpdf<false>(
                rvalue(dv,
                  cons_list(index_uni(iR),
                    cons_list(index_uni(iV), nil_index_list())), "dv"),
                predicted[((((iR - 1) * varsN) + iV) - 1)],
                (sigma * dv_sd[(iV - 1)]))), "assigning variable log_lik");}}
      for (int sym1__ = 1; sym1__ <= rowsN; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> a;
      a = std::vector<double>(varsN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(a, nil_index_list(), context__.vals_r("a"),
        "assigning variable a");
      std::vector<double> b;
      b = std::vector<double>(betaN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      assign(b, nil_index_list(), context__.vals_r("b"),
        "assigning variable b");
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
        vars__.emplace_back(a[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= betaN; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("a");
    names__.emplace_back("b");
    names__.emplace_back("sigma");
    names__.emplace_back("predicted");
    names__.emplace_back("M");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(varsN)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(betaN)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(longN)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(M_1dim__),
                                             static_cast<size_t>(M_2dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rowsN)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= betaN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= longN; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "predicted" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= M_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= M_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "M" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= rowsN; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= varsN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= betaN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= longN; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "predicted" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= M_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= M_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "M" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= rowsN; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"a\",\"type\":{\"name\":\"array\",\"length\":" << varsN << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"array\",\"length\":" << betaN << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"predicted\",\"type\":{\"name\":\"vector\",\"length\":" << longN << "},\"block\":\"transformed_parameters\"},{\"name\":\"M\",\"type\":{\"name\":\"matrix\",\"rows\":" << M_1dim__ << ",\"cols\":" << M_2dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << rowsN << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"a\",\"type\":{\"name\":\"array\",\"length\":" << varsN << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"array\",\"length\":" << betaN << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"predicted\",\"type\":{\"name\":\"vector\",\"length\":" << longN << "},\"block\":\"transformed_parameters\"},{\"name\":\"M\",\"type\":{\"name\":\"matrix\",\"rows\":" << M_1dim__ << ",\"cols\":" << M_2dim__ << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << rowsN << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_tridim_transformation_namespace::model_tridim_transformation;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_tridim_transformation_namespace::profiles__;
}
#endif
#endif
