% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{match,phylo,phylo-method}
\alias{match,phylo,phylo-method}
\alias{match,multiPhylo,phylo-method}
\alias{match,phylo,multiPhylo-method}
\alias{match,multiPhylo,multiPhylo-method}
\alias{\%in\%,multiPhylo,multiPhylo-method}
\alias{\%in\%,multiPhylo,phylo-method}
\alias{\%in\%,phylo,multiPhylo-method}
\alias{\%in\%,phylo,phylo-method}
\title{Tree matching}
\usage{
\S4method{match}{phylo,phylo}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{multiPhylo,phylo}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{phylo,multiPhylo}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{match}{multiPhylo,multiPhylo}(x, table, nomatch = NA_integer_, incomparables = NULL)

\S4method{\%in\%}{multiPhylo,multiPhylo}(x, table)

\S4method{\%in\%}{multiPhylo,phylo}(x, table)

\S4method{\%in\%}{phylo,multiPhylo}(x, table)

\S4method{\%in\%}{phylo,phylo}(x, table)
}
\arguments{
\item{x, table}{Object of class \code{phylo} or \code{multiPhylo}.}

\item{nomatch}{Integer value that will be used in place of \code{NA} in the case
where no match is found.}

\item{incomparables}{Ignored. (Included for consistency with generic.)}
}
\value{
\code{match()} returns an integer vector specifying the position in
\code{table} that matches each element in \code{x}, or \code{nomatch} if no match is found.
}
\description{
\code{match()} returns a vector of the positions of (first) matches of trees in
its first argument in its second.
\code{\%in\%} is a more intuitive interface as a binary operator, which returns
a logical vector indicating whether there is a match or not for each
tree in its left operand.
}
\examples{
tree1 <- BalancedTree(7)
trees <- c(PectinateTree(7), BalancedTree(7))

match(tree1, trees)
}
\seealso{
Corresponding base functions are documented in
\code{\link[base:match]{match()}}.

Other utility functions: 
\code{\link{ClusterTable}},
\code{\link{ClusterTable-methods}},
\code{\link{Hamming}()},
\code{\link{MSTEdges}()},
\code{\link{SampleOne}()},
\code{\link{TipTimedTree}()},
\code{\link{UnshiftTree}()},
\code{\link{as.multiPhylo}()},
\code{\link{sapply64}()},
\code{\link{sort.multiPhylo}()}
}
\concept{utility functions}
\keyword{methods}
