% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepLimma.R
\name{prep_limma}
\alias{prep_limma}
\title{Prepare limma-voom DEG data for plotting}
\usage{
prep_limma(input_path, output_name = NULL)
}
\arguments{
\item{input_path}{Path to the RDS file containing the limma-voom DEG data frame.}

\item{output_name}{Name for the processed data frame, also used as the RDS file name.}
}
\value{
A data frame with processed limma-voom DEG data.
}
\description{
This function reads a limma-voom DEG data frame from an RDS file, filters it using
\code{\link{deg_filter}} function, adjusts the logFC to absolute values, adds a pseudo-count to P.Value,
and transforms P.Value for plotting. The final data frame is returned and
optionally saved to a new RDS file.
}
\examples{
limma_file <- system.file("extdata",
                          "DEG_limma_voom_test.rds",
                          package = "TransProR")
limma <- prep_limma(limma_file)

}
