% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqdomassoc.R
\name{seqdomassoc}
\alias{seqdomassoc}
\alias{print.sdomassoc}
\title{Measures of association between domains of sequence data}
\usage{
seqdomassoc(
  seqdata.dom,
  rep.method = "overall",
  assoc = c("LRT", "V"),
  diss.dom = NULL,
  wrange = NULL,
  p.value = TRUE,
  struct.zero = TRUE,
  cross.table = FALSE,
  with.missing = FALSE,
  weighted = TRUE,
  seqrep.args = list(coverage = 0.8, pradius = 0.1),
  seqrf.args = list(k = 20),
  dnames = names(seqdata.dom)
)
}
\arguments{
\item{seqdata.dom}{List of \code{stslist} objects (one per dimension)}

\item{rep.method}{Character string. Method for determining the sequences on which the association is computed. One of "rep" (representative sequences), "eq.group" (medoids of equally spaced groups), or "overall".}

\item{assoc}{Character string. The association measure to be computed. One of "V" (Cramer V) or "LRT" or a vector with both.}

\item{diss.dom}{List of dissimilarity matrices used for selecting representatives. Ignored when \code{rep.method="overall"}.}

\item{wrange}{Vector of two integers. Window range for count of co-occurrences. A state at \code{p} in the first domain is compared with states in [\code{p+wrange[1]}, \code{p+wrange[2]}] in the second domain.}

\item{p.value}{Logical. Should p-values be returned?}

\item{struct.zero}{Logical. Should zeros in cross tables be treated as structural zeros?}

\item{cross.table}{Logical. Should cross tables be returned? If \code{TRUE}, cross tables are returned as the list attribute \code{cross.tables}.}

\item{with.missing}{Logical. Should missing be treated as a regular state.}

\item{weighted}{Logical. Should sequence weights be taken into account when present in the sequence objects? When applicable, weights of the first domain are used.}

\item{seqrep.args}{List of arguments passed to \code{\link[TraMineR]{seqrep}} when \code{rep.method="rep"}.}

\item{seqrf.args}{List of arguments passed to \code{\link[TraMineR]{seqrf}} when \code{rep.method="eq.group"}.}

\item{dnames}{String vector: names of dimensions.}
}
\value{
An object of class \code{sdomassoc}, which is the table (matrix) of association statistics with the list of cross tables in attribute \code{cross.tables}.

The print method for objects \code{sdomassoc} prints only the table of association statistics.
}
\description{
The function computes pairwise domain association based on cross-tabulation of the states observed in the sequences of the two domains involved. The association measure returned can be Cramer's V or the likelihood ratio (LRT).
}
\details{
For each pair of domains, \code{seqdomassoc} cross-tabulates the position-wise states across domains using all sequences when \code{rep.method = "overall"}.  When \code{rep.method = "rep"}, each observed sequence is first replaced by the closest representative sequence and, when \code{rep.method = "eq.group"}, each observed sequence is replaced by the group medoid of its group. Then, the selected association measures are computed on the resulting cross-tables.

The \code{"overall"} method implies a strong position-wise association and will not detect association occurring after a small time warp. With representative sequences, the same holds, but for representatives only. Using dissimilarity measures that allow for time warp for identifying representatives, observed sequences may differ from their representatives in the timing of the states. Therefore, using representatives instead of all sequences relaxes somewhat the strong timing constraint.

}
\examples{
data(biofam)

## Building one channel per type of event (left, children or married)
cases <- 1:50
bf <- as.matrix(biofam[cases, 10:25])
children <-  bf==4 | bf==5 | bf==6
married <- bf == 2 | bf== 3 | bf==6
left <- bf==1 | bf==3 | bf==5 | bf==6

## Building sequence objects
child.seq <- seqdef(children, weights = biofam[cases,'wp00tbgs'])
marr.seq <- seqdef(married, weights = biofam[cases,'wp00tbgs'])
left.seq <- seqdef(left, weights = biofam[cases,'wp00tbgs'])

## distances by channel
dchild <- seqdist(child.seq, method="OM", sm="INDELSLOG")
dmarr <- seqdist(marr.seq, method="OM", sm="INDELSLOG")
dleft <- seqdist(left.seq, method="OM", sm="INDELSLOG")
dbiofam <- list(dchild,dmarr,dleft)
dnames <- names(dbiofam) <- c("child","marr","left")


seqdomassoc(list(child.seq,marr.seq,left.seq), dnames=dnames)
seqdomassoc(list(child.seq,marr.seq,left.seq), diss.dom=dbiofam,
            rep.method="rep", assoc="V", dnames=dnames)
seqdomassoc(list(child.seq,marr.seq,left.seq), diss.dom=dbiofam,
            rep.method="eq.group", assoc="V", dnames=dnames)


}
\references{
Ritschard, G., T.F. Liao, and E. Struffolino (2023). Strategies for
multidomain sequence analysis in social research.
\emph{Sociological Methodology}, 53(2), 288-322. \doi{10.1177/00811750231163833}.
}
\seealso{
\code{\link{dissdomassoc}}
%\code{\link{print.sdomassoc}}
}
\author{
Gilbert Ritschard
}
