% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-helpers-spatial.R
\name{calculate_haversine_distance_wgs84}
\alias{calculate_haversine_distance_wgs84}
\title{Calculate distance using Haversine formula}
\usage{
calculate_haversine_distance_wgs84(lon1, lat1, lon2, lat2, unit)
}
\arguments{
\item{lon1}{Origin longitude.}

\item{lat1}{Origin latitude.}

\item{lon2}{Destination longitude vector.}

\item{lat2}{Destination latitude vector.}

\item{unit}{Output unit: "nm" or "km".}
}
\value{
List with minimum distance and corresponding index.
}
\description{
Internal function to calculate distances using the Haversine formula with WGS84 ellipsoid.
Implements the algorithm described in Sinnott (1984) for computing great circle distances.
}
\details{
The Haversine formula calculates the shortest distance between two points on a sphere
given their latitude and longitude.
}
\references{
Sinnott, R.W. (1984). Virtues of the Haversine. Sky and Telescope, 68(2), 159.

Veness, C. (2002-2022). Calculate distance, bearing and more between Latitude/Longitude points.
Movable Type Scripts. \url{https://www.movable-type.co.uk/scripts/latlong.html}
}
\keyword{internal}
