% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LU.R
\name{LU}
\alias{LU}
\title{LU Decomposition of a Complex Matrix}
\usage{
LU(A)
}
\arguments{
\item{A}{Complex, square matrix of complex numbers}
}
\value{
A lower triangular matrix L and an upper triangular matrix U so that A=LU
}
\description{
Decomposes a a matrix into the product of a lower triangular matrix and an upper triangular matrix.
}
\examples{
indices <- c(2,3,4)
z <- complex(real = rnorm(16), imag = rnorm(16))
A <- matrix(z,nrow=4)
LU(A)
}
\references{
Stewart, G. W. (1998). Matrix algorithms: volume 1: basic decompositions. Society for Industrial and Applied Mathematics.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
