% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerTOSTpaired.R
\name{powerTOSTpaired}
\alias{powerTOSTpaired}
\alias{powerTOSTpaired.raw}
\title{Power Paired Sample t-test}
\usage{
powerTOSTpaired(alpha, statistical_power, N, low_eqbound_dz, high_eqbound_dz)

powerTOSTpaired.raw(
  alpha,
  statistical_power,
  low_eqbound,
  high_eqbound,
  sdif,
  N
)
}
\arguments{
\item{alpha}{alpha used for the test (e.g., 0.05)}

\item{statistical_power}{desired power (e.g., 0.8)}

\item{N}{number of pairs (e.g., 96)}

\item{low_eqbound_dz}{lower equivalence bounds (e.g., -0.5) expressed in standardized mean difference (Cohen's dz)}

\item{high_eqbound_dz}{upper equivalence bounds (e.g., 0.5) expressed in standardized mean difference (Cohen's dz)}

\item{low_eqbound}{lower equivalence bounds (e.g., -0.5) expressed in raw mean difference}

\item{high_eqbound}{upper equivalence bounds (e.g., 0.5) expressed in raw mean difference}

\item{sdif}{standard deviation of the difference scores}
}
\value{
Calculate either achieved power, equivalence bounds, or required N, assuming a true effect size of 0.
Returns a string summarizing the power analysis, and a numeric variable for number of observations, equivalence bounds, or power.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Power analysis for TOST for dependent t-test (Cohen's dz).
This function is no longer maintained please use \link{power_t_TOST}.
}
\section{References}{

Chow, S.-C., Wang, H., & Shao, J. (2007). Sample Size Calculations in Clinical Research, Second Edition - CRC Press Book. Formula 3.1.9
}

\examples{
## Sample size for alpha = 0.05, 80\% power, equivalence bounds of
## Cohen's dz = -0.3 and Cohen's d = 0.3, and assuming true effect = 0
powerTOSTpaired(alpha=0.05,statistical_power=0.8,low_eqbound_dz=-0.3,high_eqbound_dz=0.3)

## Sample size for alpha = 0.05, N = 96 pairs, equivalence bounds of
## Cohen's dz = -0.3 and Cohen's d = 0.3, and assuming true effect = 0
powerTOSTpaired(alpha=0.05,N=96,low_eqbound_dz=-0.3,high_eqbound_dz=0.3)

## Equivalence bounds for alpha = 0.05, N = 96 pairs, statistical power of
## 0.8, and assuming true effect = 0
powerTOSTpaired(alpha=0.05,N=96,statistical_power=0.8)

## Sample size for alpha = 0.05, 80\% power, equivalence bounds of -3 and 3 in raw units
## and assuming a standard deviation of the difference scores of 10, and assuming a true effect = 0
powerTOSTpaired.raw(alpha=0.05,statistical_power=0.8,low_eqbound=-3, high_eqbound=3, sdif=10)

## Sample size for alpha = 0.05, N = 96 pairs, equivalence bounds of -3 and 3 in raw units
## and assuming a standard deviation of the difference scores of 10, and assuming a true effect = 0
powerTOSTpaired.raw(alpha=0.05,N=96,low_eqbound=-3, high_eqbound=3, sdif=10)

## Equivalence bounds for alpha = 0.05, N = 96 pairs, statistical power of 0.8
## and assuming a standard deviation of the difference scores of 10, and assuming a true effect = 0
}
