% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_t_TOST.R
\name{boot_t_TOST}
\alias{boot_t_TOST}
\alias{boot_t_TOST.default}
\alias{boot_t_TOST.formula}
\title{Bootstrapped TOST with t-tests}
\usage{
boot_t_TOST(x, ...)

\method{boot_t_TOST}{default}(
  x,
  y = NULL,
  hypothesis = "EQU",
  paired = FALSE,
  var.equal = FALSE,
  eqb,
  low_eqbound,
  high_eqbound,
  eqbound_type = "raw",
  alpha = 0.05,
  bias_correction = TRUE,
  rm_correction = FALSE,
  glass = NULL,
  mu = 0,
  R = 1999,
  boot_ci = c("stud", "basic", "perc"),
  ...
)

\method{boot_t_TOST}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{hypothesis}{'EQU' for equivalence (default), or 'MET' for minimal effects test, the alternative hypothesis.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{eqb}{Equivalence bound. Can provide 1 value (negative value is taken as the lower bound) or 2 specific values that represent the upper and lower equivalence bounds.}

\item{low_eqbound}{lower equivalence bounds (deprecated).}

\item{high_eqbound}{upper equivalence bounds (deprecated).}

\item{eqbound_type}{Type of equivalence bound. Can be set to "SMD" for standardized mean difference (i.e., Cohen's d) or  "raw" for the mean difference. Default is "raw". Raw is strongly recommended as SMD bounds will produce biased results.}

\item{alpha}{alpha level (default = 0.05)}

\item{bias_correction}{Apply Hedges' correction for bias (default is TRUE).}

\item{rm_correction}{Repeated measures correction to make standardized mean difference Cohen's d(rm). This only applies to repeated/paired samples. Default is FALSE.}

\item{glass}{A option to calculate Glass's delta as an alternative to Cohen's d type SMD. Default is NULL to not calculate Glass's delta, "glass1" will use the first group's SD as the denominator whereas "glass2" will use the 2nd group's SD.}

\item{mu}{a number indicating the true value of the mean for the two tailed test (or difference in means if you are performing a two sample test).}

\item{R}{number of bootstrap replicates}

\item{boot_ci}{type of bootstrap confidence interval. Options include studentized (stud), empirical/basic (basic) and percentile (perc) confidence intervals.}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
An S3 object of class
\code{"TOSTt"} is returned containing the following slots:
\itemize{
\item "TOST": A table of class "data.frame" containing two-tailed t-test and both one-tailed results.
\item "eqb": A table of class "data.frame" containing equivalence bound settings.
\item "effsize":  table of class "data.frame" containing effect size estimates.
\item "hypothesis": String stating the hypothesis being tested
\item "smd": List containing the results of the standardized mean difference calculations (e.g., Cohen's d).
\itemize{
\item Items include: d (estimate), dlow (lower CI bound), dhigh (upper CI bound), d_df (degrees of freedom for SMD), d_sigma (SE), d_lambda (non-centrality), J (bias correction), smd_label (type of SMD), d_denom (denominator calculation)
}
\item "alpha": Alpha level set for the analysis.
\item "method": Type of t-test.
\item "decision": List included text regarding the decisions for statistical inference.
\item "boot": List containing the bootstrap samples.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function for a bootstrap method for TOST with all types of t-tests.
}
\details{
The implemented test(s) corresponds to the proposal of Chapter 16 of Efron and Tibshirani (1994).
Returns TOSTt class object with bootstrapped based results.
Please note that the repeated measures "corrected" effect size is not available.

For two-sample tests, the test is of \eqn{\bar x - \bar y} (mean of x minus mean of y).
For paired samples, the test is of the difference scores (z),
wherein \eqn{z =  x - y}, and the test is of \eqn{\bar z} (mean of the difference scores).
For one-sample tests, the test is of \eqn{\bar x } (mean of x).

For details on the calculations in this function see \code{vignette("robustTOST")}.
}
\section{References}{


Efron, B., & Tibshirani, R. J. (1994). An introduction to the bootstrap. CRC press.
}

\seealso{
Other Robust tests: 
\code{\link{boot_log_TOST}()},
\code{\link{boot_t_test}()},
\code{\link{brunner_munzel}()},
\code{\link{log_TOST}()},
\code{\link{wilcox_TOST}()}

Other TOST: 
\code{\link{boot_log_TOST}()},
\code{\link{simple_htest}()},
\code{\link{t_TOST}()},
\code{\link{tsum_TOST}()},
\code{\link{wilcox_TOST}()}
}
\concept{Robust tests}
\concept{TOST}
