% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{beta_modelsR}
\alias{beta_modelsR}
\title{Compute the Exponential TC beta Profile-Curvature Parameter}
\usage{
beta_modelsR(betaModel, vMax, rMax, cPs, eP, vFms, TClats, dPdt, rho = 1.15)
}
\arguments{
\item{betaModel}{0=Powell (2005), 1=Holland (2008),2=Willoughby & Rahn (2004),3=Vickery & Wadhera (2008),4=Hubbert (1991)}

\item{vMax}{maximum wind speed m/s. see \code{vMax_modelsR}}

\item{rMax}{radius of maximum winds (km). see \code{rMax_modelsR}}

\item{cPs}{Tropical cyclone central pressure (hPa)}

\item{eP}{Background environmental pressure (hPa)}

\item{vFms}{Forward speed of the storm m/s}

\item{TClats}{Tropical cyclone central latitude}

\item{dPdt}{rate of change in central pressure over time, hPa per hour from Holland 2008}

\item{rho}{density of air}
}
\value{
exponential beta parameter
}
\description{
Compute the Exponential TC beta Profile-Curvature Parameter
}
\examples{
beta_modelsR(0,10,10,960,1013,3,-15,1)
}
