% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANCOVA_analytic.R
\name{ANCOVA_analytic}
\alias{ANCOVA_analytic}
\title{Power Calculations for Factorial ANCOVAs}
\usage{
ANCOVA_analytic(
  design,
  mu,
  n = NULL,
  sd,
  r2 = NULL,
  n_cov,
  alpha_level = Superpower_options("alpha_level"),
  beta_level = NULL,
  cmats = list(),
  label_list = NULL,
  design_result = NULL,
  round_up = TRUE
)
}
\arguments{
\item{design}{Output from the ANOVA_design function}

\item{mu}{Vector specifying mean for each condition}

\item{n}{Sample size in each condition}

\item{sd}{Standard deviation for all conditions (or a vector specifying the sd for each condition)}

\item{r2}{Coefficient of Determination of the model with only the covariates}

\item{n_cov}{Number of covariates}

\item{alpha_level}{Alpha level used to determine statistical significance}

\item{beta_level}{Type II error probability (power/100-1)}

\item{cmats}{List of matrices for specific contrasts of interest}

\item{label_list}{An optional list to specify the factor names and condition (recommended, if not used factors and levels are indicated by letters and numbers).}

\item{design_result}{Output from the ANOVA_design function}

\item{round_up}{Logical indicator (default = TRUE) for whether to round up sample size calculations to nearest whole number}
}
\value{
One, or two, data frames containing the power analysis results from the power analysis for the omnibus ANCOVA (main_results) or contrast tests (contrast_results).
In addition, every F-test (aov_list and con_list) is included in a list of power.htest results. 
Lastly, a (design_param) list containing the design parameters is also included in the results.
}
\description{
Complete power analyses for ANCOVA omnibus tests and contrasts. This function does not support within subjects factors.
}
\section{References}{

Shieh, G. (2020). Power analysis and sample size planning in ANCOVA designs. Psychometrika, 85(1), 101-120.
}

\examples{
# Simple 2x3 ANCOVA

ANCOVA_analytic(
design = "2b*3b",
mu = c(400, 450, 500,
      400, 500, 600),
n_cov = 3,
sd = 100,
r2 = .25,
alpha_level = .05,
beta_level = .2,
round_up = TRUE
)
}
