% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circulant.R
\name{Circulant}
\alias{Circulant}
\title{Constructor and methods for Circulant matrix objects.}
\description{
Constructor and methods for Circulant matrix objects.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Circulant$new()}}
\item \href{#method-size}{\code{Circulant$size()}}
\item \href{#method-set_acf}{\code{Circulant$set_acf()}}
\item \href{#method-get_acf}{\code{Circulant$get_acf()}}
\item \href{#method-set_psd}{\code{Circulant$set_psd()}}
\item \href{#method-get_psd}{\code{Circulant$get_psd()}}
\item \href{#method-has_acf}{\code{Circulant$has_acf()}}
\item \href{#method-prod}{\code{Circulant$prod()}}
\item \href{#method-solve}{\code{Circulant$solve()}}
\item \href{#method-log_det}{\code{Circulant$log_det()}}
\item \href{#method-clone}{\code{Circulant$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$new(N, uacf, upsd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{Size of Circulant matrix.}

\item{\code{uacf}}{Optional vector of \code{Nu = floor(N/2)+1} unique elements of the autocorrelation.}

\item{\code{upsd}}{Optional vector of \code{Nu = floor(N/2)+1} unique elements of the PSD.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circulant} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Get the size of the Circulant matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Size of the Circulant matrix.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_acf"></a>}}
\if{latex}{\out{\hypertarget{method-set_acf}{}}}
\subsection{Method \code{set_acf()}}{
Set the autocorrelation of the Circulant matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$set_acf(uacf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uacf}}{Vector of \code{Nu = floor(N/2)+1} unique elements of the autocorrelation.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_acf"></a>}}
\if{latex}{\out{\hypertarget{method-get_acf}{}}}
\subsection{Method \code{get_acf()}}{
Get the autocorrelation of the Circulant matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$get_acf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The complete autocorrelation vector of length \code{N}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_psd"></a>}}
\if{latex}{\out{\hypertarget{method-set_psd}{}}}
\subsection{Method \code{set_psd()}}{
Set the PSD of the Circulant matrix.

The power spectral density (PSD) of a Circulant matrix \code{Ct = Circulant(acf)} is defined as \code{psd = iFFT(acf)}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$set_psd(upsd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{upsd}}{Vector of \code{Nu = floor(N/2)+1} unique elements of the psd.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_psd"></a>}}
\if{latex}{\out{\hypertarget{method-get_psd}{}}}
\subsection{Method \code{get_psd()}}{
Get the PSD of the Circulant matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$get_psd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The complete PSD vector of length \code{N}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_acf"></a>}}
\if{latex}{\out{\hypertarget{method-has_acf}{}}}
\subsection{Method \code{has_acf()}}{
Check whether the autocorrelation of the Circulant matrix has been set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$has_acf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical; \code{TRUE} if \code{Circulant$set_acf()} has been called.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-prod"></a>}}
\if{latex}{\out{\hypertarget{method-prod}{}}}
\subsection{Method \code{prod()}}{
Circulant matrix-matrix product.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$prod(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Vector or matrix with \code{N} rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The matrix product \code{Ct \%*\% x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-solve"></a>}}
\if{latex}{\out{\hypertarget{method-solve}{}}}
\subsection{Method \code{solve()}}{
Solve a Circulant system of equations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$solve(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Optional vector or matrix with \code{N} rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The solution in \code{z} to the system of equations \code{Ct \%*\% z = x}.  If \code{x} is missing, returns the inverse of \code{Ct}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_det"></a>}}
\if{latex}{\out{\hypertarget{method-log_det}{}}}
\subsection{Method \code{log_det()}}{
Calculate the log-determinant of the Circulant matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$log_det()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The log-determinant \code{log(det(Ct))}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Circulant$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
