% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounded_niche.R
\name{bounded_niche}
\alias{bounded_niche}
\title{define niche from boundaries}
\usage{
bounded_niche(g_min, g_max)
}
\arguments{
\item{g_min}{lowest value of the gradient the taxon can tolerate}

\item{g_max}{highest value of the gradient the taxon can tolerate}
}
\value{
a function describing the niche for usage with \code{apply_niche}. The function returns 1 if the taxon is within its niche (the gradient is between \code{g_min} and \code{g_max}), and 0 otherwise
}
\description{
Defines a simple niche model where the niche defined is given by a lower limit (\code{g_min}) and an upper limit (\code{g_max}) of a gradient the taxon can tolerate
}
\examples{

x = seq(0, 10, by = 0.2)
f = bounded_niche(2,5)
plot(x, f(x), type = "l",
xlab = "Gradient", ylab = "Observation probability",
main = "Observation probability of taxon")

# see also
#vignette("event_data")
# for details how to use this functionality


}
\seealso{
\itemize{
\item \code{\link[=snd_niche]{snd_niche()}} for an alternative niche model
\item \code{\link[=discrete_niche]{discrete_niche()}} for defining niches based on discrete categories
\item \code{\link[=apply_niche]{apply_niche()}} for the function that uses the function returned
\item \code{vignette("advanced_functionality")} for details how to create user-defined niche models
}
}
