% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footprinting.R
\name{GetFootprintData}
\alias{GetFootprintData}
\title{Get footprinting data}
\usage{
GetFootprintData(
  object,
  features,
  assay = NULL,
  group.by = NULL,
  idents = NULL
)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{A vector of features to extract data for}

\item{assay}{Name of assay to use}

\item{group.by}{A grouping variable}

\item{idents}{Set of identities to group cells by}
}
\value{
Returns a data.frame with the following columns:
\itemize{
  \item{group: Cell group (determined by group.by parameter}
  \item{position: Position relative to motif center}
  \item{count: Normalized Tn5 insertion counts at each position}
  \item{norm.value: Normalized Tn5 insertion counts at each position (same as count)}
  \item{feature: Name of the footprinted motif}
  \item{class: observed or expected}
 }
}
\description{
Extract footprint data for a set of transcription factors or metafeatures.
This function will pull accessibility data for a given feature (eg, a TF),
and perform background normalization for each identity class. This is the
data that's used to create TF footprinting plots with the
\code{PlotFootprint} function.
}
\concept{footprinting}
