% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util_Invalsi_filter.R
\name{Util_Invalsi_filter}
\alias{Util_Invalsi_filter}
\title{Filter the Invalsi data by subject, school grade and year.}
\usage{
Util_Invalsi_filter(
  data = NULL,
  subj = c("ELI", "ERE", "ITA", "MAT"),
  grade = 8,
  level = "LAU",
  WLE = FALSE,
  Year = 2023,
  verbose = TRUE,
  autoAbort = FALSE
)
}
\arguments{
\item{data}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The raw Invalsi survey data that has to be filtered, obtained as output of the \code{\link{Get_Invalsi_IS}} function.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{subj}{Character. The school subject(s) to include, among \code{"Englis_listening"}/\code{"ELI"}, \code{"English_reading"}/\code{"ERE"}, \code{"Italian"}/\code{"ITA"} and \code{"Mathematics"}/\code{"MAT"}. All four by default.}

\item{grade}{Numeric. The school grade to chose. Either \code{2} (2nd year of primary school), \code{5} (last year of primary school), \code{8} (last year of middle shcool), \code{10} (2nd year of high school) or \code{13} (last year of school). \code{8} by default}

\item{level}{Character. The level of aggregation of Invalsi census data. Either \code{"NUTS-3"}, \code{"Province"}, \code{"LAU"}, \code{"Municipality"}.
If an input dataframe is provided, please select the same level of aggregation. \code{"LAU"} by default}

\item{WLE}{Logical. Whether the variable to choose should be the average WLE score rather that the percentage of sufficient tests, if both are available. \code{FALSE} by default}

\item{Year}{Numeric or character value. Reference school year for the data (last available is 2022/23).
Available in the formats: \code{2022}, \code{"2021/2022"}, \code{202122}, \code{20212022}. \code{2023} by default}

\item{verbose}{Logical. If \code{TRUE}, the function informs about the time needed. \code{TRUE} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. For all subjects and school grades, the variables indicate:

\itemize{
\item \code{M} The mean score, either WLE or percentage of sufficient tests
\item \code{S} The standard deviation of the score
\item \code{C} The students coverage percentage (expressed in the scale 1 - 100)
}
}
\description{
This function filters the database of Invalsi scores (see \code{\link{Get_Invalsi_IS}}) by school year, education grade and subject and returns a dataframe in wide format.
Each row corresponds to one territorial unit (either municipality or province); the numerical variables are three (the mean score, the score's standard deviation and the students coverage percentage) for each selected subject.
}
\examples{



Util_Invalsi_filter(subj = c("Italian", "Mathematics"), grade = 5, level = "NUTS-3", Year = 2023,
                   WLE = FALSE, data = example_Invalsi23_prov)

Util_Invalsi_filter(subj = c("Italian", "Mathematics"), grade = 5, level = "NUTS-3", Year = 2023,
                    WLE = TRUE, data = example_Invalsi23_prov)

Invalsi23_high <- Util_Invalsi_filter(subj = "Italian", grade = c(10,13), level = "NUTS-3",
                                      Year = 2023, data = example_Invalsi23_prov)


 summary(Invalsi23_high)

}
