% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glances.R
\name{glances.SSN2}
\alias{glances.SSN2}
\alias{glances.ssn_lm}
\alias{glances.ssn_glm}
\title{Glance at many fitted model objects}
\usage{
\method{glances}{ssn_lm}(object, ..., sort_by = "AICc", decreasing = FALSE)

\method{glances}{ssn_glm}(object, ..., sort_by = "AICc", decreasing = FALSE)
}
\arguments{
\item{object}{Fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Additional fitted model objects from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{sort_by}{Sort by a \code{glance} statistic (i.e., the name of a column
output from \code{glance()} or the order of model input (\code{sort_by = "order"}).
The default is \code{"AICc"}.}

\item{decreasing}{Should \code{sort_by} be decreasing or not? The default is \code{FALSE}.}
}
\value{
A tibble where each row represents the output of \code{glance()} for
each fitted model object.
}
\description{
\code{glances()} repeatedly calls \code{glance()} on several
fitted model objects and binds the output together, sorted by a column of interest.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

# tailup only
ssn_mod1 <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
# taildown only
ssn_mod2 <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  taildown_type = "exponential"
)
glances(ssn_mod1, ssn_mod2)
}
