% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Torgegram.R
\name{Torgegram}
\alias{Torgegram}
\title{Compute the empirical semivariogram}
\usage{
Torgegram(
  formula,
  ssn.object,
  type = c("flowcon", "flowuncon"),
  bins = 15,
  cutoff,
  partition_factor
)
}
\arguments{
\item{formula}{A formula describing the fixed effect structure.}

\item{ssn.object}{A spatial stream network object with class \code{SSN}.}

\item{type}{The Torgegram type. A vector with possible values \code{"flowcon"}
for flow-connected distances, \code{"flowuncon"} for flow-unconnected distances,
and \code{"euclid"} for Euclidean distances. The default is to show both
flow-connected and flow-unconnected distances.}

\item{bins}{The number of equally spaced bins. The default is 15.}

\item{cutoff}{The maximum distance considered.
The default is half the diagonal of the bounding box from the coordinates.}

\item{partition_factor}{An optional formula specifying the partition factor.
If specified, semivariances are only computed for observations sharing the
same level of the partition factor.}
}
\value{
A list with elements correspond to \code{type}. Each element
is data frame with distance bins (\code{bins}), the  average distance
(\code{dist}), the semivariance (\code{gamma}), and the
number of (unique) pairs (\code{np}) for the respective \code{type}.
}
\description{
Compute the empirical semivariogram for varying bin sizes and
cutoff values.
}
\details{
The Torgegram is an empirical semivariogram is a tool used to visualize and model
spatial dependence by estimating the semivariance of a process at varying distances
separately for flow-connected, flow-unconnected, and Euclidean distances.
For a constant-mean process, the
semivariance at distance \eqn{h} is denoted \eqn{\gamma(h)} and defined as
\eqn{0.5 * Var(z1  - z2)}. Under second-order stationarity,
\eqn{\gamma(h) = Cov(0) - Cov(h)}, where \eqn{Cov(h)} is the covariance function
at distance \code{h}. Typically the residuals from an ordinary
least squares fit defined by \code{formula} are second-order stationary with
mean zero. These residuals are used to compute the empirical semivariogram.
At a distance \code{h}, the empirical semivariance is
\eqn{1/N(h) \sum (r1 - r2)^2}, where \eqn{N(h)} is the number of (unique)
pairs in the set of observations whose distance separation is \code{h} and
\code{r1} and \code{r2} are residuals corresponding to observations whose
distance separation is \code{h}. In spmodel, these distance bins actually
contain observations whose distance separation is \code{h +- c},
where \code{c} is a constant determined implicitly by \code{bins}. Typically,
only observations whose distance separation is below some cutoff are used
to compute the empirical semivariogram (this cutoff is determined by \code{cutoff}).
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

tg <- Torgegram(Summer_mn ~ 1, mf04p)
plot(tg)
}
\references{
Zimmerman, D. L., & Ver Hoef, J. M. (2017). The Torgegram for fluvial
variography: characterizing spatial dependence on stream networks.
\emph{Journal of Computational and Graphical Statistics},
\bold{26(2)}, 253--264.
}
\seealso{
\code{\link[=plot.Torgegram]{plot.Torgegram()}}
}
