% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeHierFormula.R
\encoding{UTF8}
\name{MakeHierFormula}
\alias{MakeHierFormula}
\title{Make model formula from data taking into account hierarchical variables}
\usage{
MakeHierFormula(
  data = NULL,
  hGroups = HierarchicalGroups2(data),
  n = length(hGroups),
  sim = TRUE
)
}
\arguments{
\item{data}{data frame}

\item{hGroups}{Output from HierarchicalGroups2()}

\item{n}{Interaction level or 0 (all levels)}

\item{sim}{Include "~" when TRUE}
}
\value{
Formula as character string
}
\description{
Make model formula from data taking into account hierarchical variables
}
\examples{
x <- SSBtoolsData("sprt_emp_withEU")[, -4]
MakeHierFormula(x)
MakeHierFormula(x, n = 2)
MakeHierFormula(x, n = 0)
}
\author{
Øyvind Langsrud
}
