#' Soil carbon and nitrogen
#'
#' Percentage of carbon and nitrogen in irrigated and non-irrigated plots.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 28 rows (each plot) and 4 columns:
#' \describe{
#'   \item{IrrigatedC}{The percentage carbon, in a paired irrigated plot}
#'   \item{NonirrigatedC}{The percentage carbon, in a paired non-irrigated plot}
#'   \item{IrrigatedN}{The percentage nitrogen, in a paired irrigated plot}
#'   \item{NonirrigatedN}{The percentage nitrogen, in a paired non-irrigated plot}
#' }
#' @source 
#' Lambie, S. M., Mudge, P. L., & Stevenson, B. A. (2021). 
#' Microbial community composition and activity in paired irrigated and 
#' non-irrigated pastures in New Zealand. 
#' \emph{Soil Research}, \bold{60}(4), 337--348.
#' 
#' @usage 
#' data(SoilCN)
#' 
#' @examples
#' plot(IrrigatedC ~ NonirrigatedC, data = SoilCN)
#' 

"SoilCN"
