% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{myGrid}
\alias{myGrid}
\alias{print.myGrid}
\alias{summary.myGrid}
\alias{plot.myGrid}
\alias{myGrid-class}
\title{Methods for 'myGrid' objects.}
\usage{
\method{print}{myGrid}(x, ...)

\method{summary}{myGrid}(object, ...)

\method{plot}{myGrid}(x, show.names = TRUE, names = 1:prod(x$dim), ...)
}
\arguments{
\item{x}{\code{myGrid} object}

\item{\dots}{Further arguments to the \code{\link{plot}} function.}

\item{object}{\code{myGrid} object}

\item{show.names}{Whether the cluster names must be printed in center of
the grid or not. Default to \code{TRUE} (names not displayed).}

\item{names}{If \code{show.names = TRUE}, values of the names to 
display. Default to the cluster number.}
}
\description{
Methods for the result of \code{\link{initGrid}}
(\code{myGrid} object)
}
\details{
The \code{myGrid} class has the following entries:
\itemize{
  \item{\code{coord}} 2-column matrix with x and y coordinates of the grid 
  units
  \item{\code{topo}} topology of the grid;
  \item{\code{dim}} dimensions of the grid (width corresponds to x 
  coordinates)
  \item{\code{dist.type}} distance type that defines the topology of the 
  grid.
}
During plotting, the color filling process uses the coordinates of the object
\code{x} included in \code{x$coord}.
}
\examples{
# creating grid
a.grid <- initGrid(dimension=c(5,5), topo="square", dist.type="maximum")

# plotting grid
# without any color specification
plot(a.grid)
# generating colors from rainbow() function
my.colors <- grDevices::rainbow(5*5)
plot(a.grid) + ggplot2::scale_fill_manual(values = my.colors)
}
\seealso{
\code{\link{initGrid}} to define a \code{myGrid} class object.
}
\author{
Élise Maigné \email{elise.maigne@inrae.fr}\cr
Madalina Olteanu, \email{olteanu@ceremade.dauphine.fr}\cr
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}
}
