% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeForest.R
\name{mergeForest}
\alias{mergeForest}
\title{Merge two forests}
\usage{
mergeForest(fit1, fit2)
}
\arguments{
\item{fit1}{first \code{SDForest} object}

\item{fit2}{second \code{SDForest} object}
}
\value{
merged \code{SDForest} object
set.seed(1)
n <- 50
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
fit1 <- SDForest(x = X, y = y, Q_type = 'no_deconfounding', nTree = 5, cp = 0.5)
fit2 <- SDForest(x = X, y = y, nTree = 5, cp = 0.5)
mergeForest(fit1, fit2)
}
\description{
This function merges two forests. 
The trees are combined and the variable importance is 
calculated as a weighted average of the two forests. 
If the forests are trained on the same data, 
the predictions and oob_predictions are combined as well.
}
\author{
Markus Ulmer
}
