#' Get maximum number of broad clusters
#'
#' @param fullcluster A list of clusters that generated by the function GetCluster()
#'
#' @return A list
#' @export
#'
#' @examples
#' data(sim_result)
#' SCout <- SummCluster(sim_result[[1]])

SummCluster <- function(fullcluster) {
  nbroad <- c()
  refindClust <- list()
  for(i in seq_along(fullcluster)) {
    nbroad <- c(nbroad, length(unique(fullcluster[[i]]$broadcluster)))

    onetmp <- fullcluster[[i]][which(!duplicated(fullcluster[[i]][,2])), ]
    refindClust[[i]] <- onetmp[order(onetmp[,2]), ]
  }

  return(list(nbroad = nbroad,
              refindClust = refindClust))
}
