\name{evaluate}
\alias{evaluate}
\alias{evaluate.SCA}
\alias{evaluate.SCE}
\alias{SCA_Model_evaluation}
\alias{SCE_Model_evaluation}

\title{
  Model Evaluation
}

\description{
  Functions for evaluating model performance using comprehensive metrics. The package provides both generic S3 methods and direct function calls for model evaluation.
}

\usage{
evaluate(object, ...)

\method{evaluate}{SCA}(object, Testing_data, Predictant, digits = 3, ...)

\method{evaluate}{SCE}(object, Testing_data, Training_data, Predictant, digits = 3, ...)

SCA_Model_evaluation(Testing_data, Simulations, Predictant, digits = 3)

SCE_Model_evaluation(Testing_data, Training_data, Simulations, Predictant, digits = 3)
}

\arguments{
  \item{object}{
    An object for which performance should be evaluated.
  }
  \item{Testing_data}{
    A data.frame containing the observations used during model testing.
    Must include all specified predictants.
  }
  \item{Training_data}{
    A data.frame containing the observations used during model training.
    Required only for SCE objects and \code{SCE_Model_evaluation}.
  }
  \item{Simulations}{
    A list containing model predictions:
    \itemize{
      \item For SCE: must contain 'Training', 'Validation', and 'Testing' components
      \item For SCA: must contain 'Testing_sim' component
    }
    The structure should align with the output generated by the respective model training function.
  }
  \item{Predictant}{
    A character vector specifying the name(s) of the dependent variable(s) to be evaluated
    (e.g., c("swvl3", "swvl4")). The specified names must exactly match those used in model training.
  }
  \item{digits}{
    An integer specifying the number of decimal places to retain when reporting
    evaluation metrics. Default value is 3.
  }
  \item{...}{
    Additional arguments passed to methods.
  }
}

\value{
  For SCA models and \code{SCA_Model_evaluation}:
  \itemize{
    \item If single predictant: Returns a data.frame with column "Testing"
    \item If multiple predictants: Returns a list of data.frames, one for each predictant
  }
  
  For SCE models and \code{SCE_Model_evaluation}:
  \itemize{
    \item If single predictant: Returns a data.frame with columns "Training", "Validation", and "Testing"
    \item If multiple predictants: Returns a list of data.frames, one for each predictant
  }
  
  Each data.frame contains the following metrics:
  \itemize{
    \item MAE: Mean Absolute Error (mean(abs(obs - sim)))
    \item RMSE: Root Mean Square Error (sqrt(mean((obs - sim)^2)))
    \item NSE: Nash-Sutcliffe Efficiency (1 - (sum((obs - sim)^2) / sum((obs - mean(obs))^2)))
    \item Log.NSE: NSE calculated on log-transformed values
    \item R2: R-squared calculated using linear regression
    \item kge: Kling-Gupta Efficiency (1 - sqrt((r-1)^2 + (alpha-1)^2 + (beta-1)^2))
  }
}

\details{
  \strong{Evaluation Metrics:}
  
  The functions evaluate model performance using six distinct metrics:
  \enumerate{
    \item \strong{MAE (Mean Absolute Error)}: Average absolute difference between observed and predicted values
    \item \strong{RMSE (Root Mean Square Error)}: Square root of the average squared differences
    \item \strong{NSE (Nash-Sutcliffe Efficiency)}: Measures the relative magnitude of residual variance compared to observed variance
    \item \strong{Log.NSE}: NSE calculated on log-transformed values for better handling of skewed distributions
    \item \strong{R2 (R-squared)}: Coefficient of determination from linear regression
    \item \strong{KGE (Kling-Gupta Efficiency)}: Combines correlation, bias, and variability ratio
  }
  
  \strong{Function Differences:}
  \itemize{
    \item \code{evaluate.SCA()}: S3 method for single SCA trees (calls \code{SCA_Model_evaluation})
    \item \code{evaluate.SCE()}: S3 method for SCE ensembles (calls \code{SCE_Model_evaluation})
    \item \code{SCA_Model_evaluation()}: Direct function for SCA model evaluation
    \item \code{SCE_Model_evaluation()}: Direct function for SCE model evaluation
  }
  
  \strong{Input Validation:}
  The functions perform comprehensive input validation:
  \enumerate{
    \item Data frame structure validation
    \item Presence of required components in Simulations list
    \item Existence of predictants in both data and simulations
    \item Matching row counts between data and simulations
    \item Proper handling of NaN values and zero/negative values
  }
  
  \strong{Data Processing:}
  \enumerate{
    \item Removes NaN values from both observed and simulated data
    \item Handles zero or negative values by replacing them with 0.0001
    \item Calculates all six metrics for each predictant
    \item Formats the results with specified number of decimal places
  }
}

\author{
  Kailong Li <lkl98509509@gmail.com>
}

\seealso{
  \code{\link{SCA}}, \code{\link{SCE}}
}

