% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmvnorm}
\alias{rmvnorm}
\title{Draw from multivariate normal distribution}
\usage{
rmvnorm(mu, Sigma)
}
\arguments{
\item{mu}{The mean vector of length \code{n}.}

\item{Sigma}{The covariance matrix of dimension \code{n} x \code{n}.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
This function draws from a multivariate normal distribution.
}
\details{
The function builds upon the following fact: If \eqn{\epsilon = (\epsilon_1,\dots,\epsilon_n)},
where each \eqn{\epsilon_i} is drawn independently from a standard normal distribution,
then \eqn{\mu+L\epsilon} is a draw from the multivariate normal distribution
\eqn{N(\mu,\Sigma)}, where \eqn{L} is the lower triangular factor of the
Choleski decomposition of \eqn{\Sigma}.
}
\examples{
mu <- c(0,0)
Sigma <- diag(2)
rmvnorm(mu = mu, Sigma = Sigma)
}
\keyword{distribution}
\keyword{internal}
