% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robin_glm.R
\name{robin_glm}
\alias{robin_glm}
\title{Covariate adjusted glm model}
\usage{
robin_glm(
  formula,
  data,
  treatment,
  contrast = "difference",
  contrast_jac = NULL,
  vcov = "vcovG",
  family = gaussian(),
  vcov_args = list(),
  pair,
  ...
)
}
\arguments{
\item{formula}{(\code{formula}) A formula of analysis.}

\item{data}{(\code{data.frame}) Input data frame.}

\item{treatment}{(\code{formula} or \code{character(1)}) A formula of treatment assignment or assignment by stratification,
or a string name of treatment assignment.}

\item{contrast}{(\code{function} or \code{character(1)}) A function to calculate the treatment effect, or character of
"difference", "risk_ratio", "odds_ratio" for default contrasts.}

\item{contrast_jac}{(\code{function}) A function to calculate the Jacobian of the contrast function. Ignored if using
default contrasts.}

\item{vcov}{(\code{function}) A function to calculate the variance-covariance matrix of the treatment effect,
including \code{vcovHC} and \code{vcovG}.}

\item{family}{(\code{family}) A family object of the glm model.}

\item{vcov_args}{(\code{list}) Additional arguments passed to \code{vcov}.}

\item{pair}{Pairwise treatment comparison.}

\item{...}{Additional arguments passed to \code{glm} or \code{glm.nb}.}
}
\value{
A treatment_effect object.
}
\description{
Covariate adjusted glm model
}
\details{
If family is \code{MASS::negative.binomial(NA)}, the function will use \code{MASS::glm.nb} instead of \code{glm}.
}
\examples{
robin_glm(
  y ~ treatment * s1,
  data = dummy_data,
  treatment = treatment ~ s1, contrast = "difference"
)
}
