% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap03correlation.R
\name{wrap.correlation}
\alias{wrap.correlation}
\title{Prepare Data on Correlation Manifold}
\usage{
wrap.correlation(input)
}
\arguments{
\item{input}{correlation data matrices to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{array}{an \eqn{(p\times p\times n)} array where each slice along 3rd dimension is a correlation matrix.}
\item{list}{a length-\eqn{n} list whose elements are \eqn{(p\times p)} correlation matrices.}
}}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of \eqn{(p\times p)} correlation matrices.}
  \item{size}{size of each correlation matrix.}
  \item{name}{name of the manifold of interests, \emph{"correlation"}}
}
}
\description{
The collection of correlation matrices is considered as a subset (and quotient) of 
the well-known SPD manifold. In our package, it is defined as
\deqn{\mathcal{C}_{++}^p = \lbrace X \in \mathbf{R}^{p\times p} ~\vert~ X^\top = X,~ \textrm{rank}(X)=p,~ \textrm{diag}(X) = 1 \rbrace}
where the rank condition means it is strictly positive definite. Please note that 
the geometry involving semi-definite correlation matrices is not the objective here.
}
\examples{
#-------------------------------------------------------------------
#                 Checker for Two Types of Inputs
#
#  5 observations; empirical correlation of normal observations.
#-------------------------------------------------------------------
#  Data Generation
d1 = array(0,c(3,3,5))
d2 = list()
for (i in 1:5){
  dat = matrix(rnorm(10*3),ncol=3)
  d1[,,i] = stats::cor(dat)
  d2[[i]] = d1[,,i]
}

#  Run
test1 = wrap.correlation(d1)
test2 = wrap.correlation(d2)

}
\concept{wrapper}
